/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.langchain;

import dev.braintrust.instrumentation.langchain.OtelContextPassingExecutor;
import dev.braintrust.instrumentation.langchain.TracingProxy;
import dev.braintrust.instrumentation.langchain.TracingToolExecutor;
import dev.braintrust.instrumentation.langchain.WrappedHttpClient;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.tool.ToolExecutor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraintrustLangchain {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustLangchain.class);
    private static final String INSTRUMENTATION_NAME = "braintrust-langchain4j";

    public static <T> T wrap(OpenTelemetry openTelemetry, AiServices<T> aiServices) {
        try {
            AiServiceContext context = (AiServiceContext)BraintrustLangchain.getPrivateField(aiServices, "context");
            Tracer tracer = openTelemetry.getTracer(INSTRUMENTATION_NAME);
            ChatModel chatModel = context.chatModel;
            StreamingChatModel streamingChatModel = context.streamingChatModel;
            if (chatModel != null) {
                if (chatModel instanceof OpenAiChatModel) {
                    oaiModel = (OpenAiChatModel)chatModel;
                    aiServices.chatModel((ChatModel)BraintrustLangchain.wrap(openTelemetry, (OpenAiChatModel)oaiModel));
                } else {
                    log.warn("unsupported model: {}. LLM calls will not be instrumented", (Object)chatModel.getClass().getName());
                }
            } else if (streamingChatModel != null) {
                if (streamingChatModel instanceof OpenAiStreamingChatModel) {
                    oaiModel = (OpenAiStreamingChatModel)streamingChatModel;
                    aiServices.streamingChatModel((StreamingChatModel)BraintrustLangchain.wrap(openTelemetry, (OpenAiStreamingChatModel)oaiModel));
                } else {
                    log.warn("unsupported model: {}. LLM calls will not be instrumented", (Object)streamingChatModel.getClass().getName());
                }
            } else {
                throw new RuntimeException("model or chat model must be set");
            }
            if (context.toolService != null) {
                for (Map.Entry entry : context.toolService.toolExecutors().entrySet()) {
                    String toolName = (String)entry.getKey();
                    ToolExecutor original = (ToolExecutor)entry.getValue();
                    entry.setValue(new TracingToolExecutor(original, toolName, tracer));
                }
                Executor underlyingExecutor = context.toolService.executor();
                if (underlyingExecutor != null) {
                    aiServices.executeToolsConcurrently((Executor)new OtelContextPassingExecutor(underlyingExecutor));
                }
            }
            Object service = aiServices.build();
            Class clazz = context.aiServiceClass;
            return (T)TracingProxy.create(clazz, service, tracer);
        }
        catch (Exception e) {
            log.warn("failed to apply langchain AI services instrumentation", (Throwable)e);
            return (T)aiServices.build();
        }
    }

    public static OpenAiChatModel wrap(OpenTelemetry otel, OpenAiChatModel.OpenAiChatModelBuilder builder) {
        return BraintrustLangchain.wrap(otel, builder.build());
    }

    private static OpenAiChatModel wrap(OpenTelemetry otel, OpenAiChatModel model) {
        try {
            Object internalClient = BraintrustLangchain.getPrivateField(model, "client");
            HttpClient httpClient = (HttpClient)BraintrustLangchain.getPrivateField(internalClient, "httpClient");
            if (httpClient instanceof WrappedHttpClient) {
                log.debug("model already instrumented. skipping: {}", httpClient.getClass());
                return model;
            }
            WrappedHttpClient wrappedHttpClient = new WrappedHttpClient(otel, httpClient, new Options("openai"));
            BraintrustLangchain.setPrivateField(internalClient, "httpClient", wrappedHttpClient);
            return model;
        }
        catch (Exception e) {
            log.warn("failed to instrument OpenAiChatModel", (Throwable)e);
            return model;
        }
    }

    public static OpenAiStreamingChatModel wrap(OpenTelemetry otel, OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder builder) {
        return BraintrustLangchain.wrap(otel, builder.build());
    }

    public static OpenAiStreamingChatModel wrap(OpenTelemetry otel, OpenAiStreamingChatModel model) {
        try {
            Object internalClient = BraintrustLangchain.getPrivateField(model, "client");
            HttpClient httpClient = (HttpClient)BraintrustLangchain.getPrivateField(internalClient, "httpClient");
            if (httpClient instanceof WrappedHttpClient) {
                log.debug("model already instrumented. skipping: {}", httpClient.getClass());
                return model;
            }
            WrappedHttpClient wrappedHttpClient = new WrappedHttpClient(otel, httpClient, new Options("openai"));
            BraintrustLangchain.setPrivateField(internalClient, "httpClient", wrappedHttpClient);
            return model;
        }
        catch (Exception e) {
            log.warn("failed to instrument OpenAiStreamingChatModel", (Throwable)e);
            return model;
        }
    }

    private static <T> T getPrivateField(Object obj, String fieldName) throws ReflectiveOperationException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return (T)field.get(obj);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    private static void setPrivateField(Object obj, String fieldName, Object value) throws ReflectiveOperationException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(obj, value);
                return;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    public record Options(String providerName) {
    }
}

