/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.langchain;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;

class OtelContextPassingExecutor
implements Executor {
    private final Executor underlying;

    public OtelContextPassingExecutor(Executor executor) {
        this.underlying = executor;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        Context context = Context.current();
        this.underlying.execute(() -> {
            try (Scope ignored = context.makeCurrent();){
                command.run();
            }
        });
    }
}

