/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.langchain;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.jspecify.annotations.NonNull;

class TracingProxy {
    public static <T> @NonNull T create(Class<T> serviceInterface, T service, Tracer tracer) {
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, (proxy, method, args) -> {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(service, args);
            }
            Span span = tracer.spanBuilder(method.getName()).startSpan();
            try {
                Object object;
                block13: {
                    Scope ignored = span.makeCurrent();
                    try {
                        method.setAccessible(true);
                        object = method.invoke(service, args);
                        if (ignored == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            span.setStatus(StatusCode.ERROR, cause.getMessage());
                            span.recordException(cause);
                            throw cause;
                        }
                        catch (Exception e) {
                            span.setStatus(StatusCode.ERROR, e.getMessage());
                            span.recordException((Throwable)e);
                            throw e;
                        }
                    }
                    ignored.close();
                }
                return object;
            }
            finally {
                span.end();
            }
        });
    }

    private TracingProxy() {
    }
}

