/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.langchain;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.service.tool.ToolExecutionResult;
import dev.langchain4j.service.tool.ToolExecutor;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TracingToolExecutor
implements ToolExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingToolExecutor.class);
    static final String TYPE_TOOL_JSON = "{\"type\":\"tool\"}";
    private final ToolExecutor delegate;
    private final String toolName;
    private final Tracer tracer;

    TracingToolExecutor(ToolExecutor delegate, String toolName, Tracer tracer) {
        this.delegate = delegate;
        this.toolName = toolName;
        this.tracer = tracer;
    }

    public String execute(ToolExecutionRequest request, Object memoryId) {
        Span span = this.tracer.spanBuilder(this.toolName).startSpan();
        try {
            String string;
            block11: {
                Scope ignored = span.makeCurrent();
                try {
                    String result = this.delegate.execute(request, memoryId);
                    this.setSpanAttributes(span, request, result);
                    string = result;
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        span.setStatus(StatusCode.ERROR, e.getMessage());
                        span.recordException((Throwable)e);
                        throw e;
                    }
                }
                ignored.close();
            }
            return string;
        }
        finally {
            span.end();
        }
    }

    public ToolExecutionResult executeWithContext(ToolExecutionRequest request, InvocationContext context) {
        Span span = this.tracer.spanBuilder(this.toolName).startSpan();
        try {
            ToolExecutionResult toolExecutionResult;
            block11: {
                Scope ignored = span.makeCurrent();
                try {
                    ToolExecutionResult result = this.delegate.executeWithContext(request, context);
                    this.setSpanAttributes(span, request, result.resultText());
                    toolExecutionResult = result;
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        span.setStatus(StatusCode.ERROR, e.getMessage());
                        span.recordException((Throwable)e);
                        throw e;
                    }
                }
                ignored.close();
            }
            return toolExecutionResult;
        }
        finally {
            span.end();
        }
    }

    private void setSpanAttributes(Span span, ToolExecutionRequest request, @Nullable String toolCallResult) {
        try {
            span.setAttribute("braintrust.span_attributes", TYPE_TOOL_JSON);
            String args = request.arguments();
            if (args != null && !args.isEmpty()) {
                span.setAttribute("braintrust.input_json", args);
            }
            if (toolCallResult != null) {
                span.setAttribute("braintrust.output", toolCallResult);
            }
        }
        catch (Exception e) {
            log.debug("Failed to set tool span attributes", (Throwable)e);
        }
    }
}

