/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.langchain;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.braintrust.instrumentation.langchain.BraintrustLangchain;
import dev.braintrust.trace.BraintrustTracing;
import dev.langchain4j.exception.HttpException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventContext;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WrappedHttpClient
implements HttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WrappedHttpClient.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final Tracer tracer;
    private final HttpClient underlying;
    private final BraintrustLangchain.Options options;

    public WrappedHttpClient(OpenTelemetry openTelemetry, HttpClient underlying, BraintrustLangchain.Options options) {
        this.tracer = BraintrustTracing.getTracer(openTelemetry);
        this.underlying = underlying;
        this.options = options;
    }

    public SuccessfulHttpResponse execute(HttpRequest request) throws HttpException, RuntimeException {
        ProviderInfo providerInfo = new ProviderInfo(this.options.providerName(), WrappedHttpClient.extractEndpoint(request));
        Span span = this.startNewSpan(WrappedHttpClient.getSpanName(providerInfo));
        try {
            SuccessfulHttpResponse successfulHttpResponse;
            block11: {
                Scope scope = span.makeCurrent();
                try {
                    WrappedHttpClient.tagSpan(span, request, providerInfo);
                    long startTime = System.nanoTime();
                    SuccessfulHttpResponse response = this.underlying.execute(request);
                    long endTime = System.nanoTime();
                    double timeToFirstToken = (double)(endTime - startTime) / 1.0E9;
                    WrappedHttpClient.tagSpan(span, response, providerInfo, timeToFirstToken);
                    successfulHttpResponse = response;
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        WrappedHttpClient.tagSpan(span, t);
                        throw t;
                    }
                }
                scope.close();
            }
            return successfulHttpResponse;
        }
        finally {
            span.end();
        }
    }

    public void execute(HttpRequest request, ServerSentEventListener listener) {
        if (listener instanceof WrappedServerSentEventListener) {
            this.underlying.execute(request, listener);
            return;
        }
        ProviderInfo providerInfo = new ProviderInfo(this.options.providerName(), WrappedHttpClient.extractEndpoint(request));
        Span span = this.startNewSpan(WrappedHttpClient.getSpanName(providerInfo));
        try (Scope ignored = span.makeCurrent();){
            WrappedHttpClient.tagSpan(span, request, providerInfo);
            this.underlying.execute(request, (ServerSentEventListener)new WrappedServerSentEventListener(listener, span, providerInfo));
        }
        catch (Throwable t) {
            WrappedHttpClient.tagSpan(span, t);
            span.end();
            throw t;
        }
    }

    public void execute(HttpRequest request, ServerSentEventParser parser, ServerSentEventListener listener) {
        if (listener instanceof WrappedServerSentEventListener) {
            this.underlying.execute(request, parser, listener);
            return;
        }
        ProviderInfo providerInfo = new ProviderInfo(this.options.providerName(), WrappedHttpClient.extractEndpoint(request));
        Span span = this.startNewSpan(WrappedHttpClient.getSpanName(providerInfo));
        try (Scope ignored = span.makeCurrent();){
            WrappedHttpClient.tagSpan(span, request, providerInfo);
            this.underlying.execute(request, parser, (ServerSentEventListener)new WrappedServerSentEventListener(listener, span, providerInfo));
        }
        catch (Throwable t) {
            WrappedHttpClient.tagSpan(span, t);
            span.end();
            throw t;
        }
    }

    private static String extractEndpoint(HttpRequest request) {
        try {
            URI uri = new URI(request.url());
            return uri.getPath();
        }
        catch (Exception e) {
            log.debug("Failed to parse URL: {}", (Object)request.url(), (Object)e);
            return "";
        }
    }

    private static String getSpanName(ProviderInfo info) {
        if (info.endpoint.contains("/chat/completions") || info.endpoint.contains("/v1/completions")) {
            return "Chat Completion";
        }
        if (info.endpoint.contains("/embeddings")) {
            return "Embeddings";
        }
        if (info.endpoint.contains("/messages")) {
            return "Messages";
        }
        return info.endpoint();
    }

    private Span startNewSpan(String spanName) {
        return this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.CLIENT).startSpan();
    }

    private static void tagSpan(Span span, HttpRequest request, ProviderInfo providerInfo) {
        try {
            span.setAttribute("braintrust.span_attributes", WrappedHttpClient.json(Map.of("type", "llm")));
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("provider", providerInfo.provider);
            String body = request.body();
            if (body != null && !body.isEmpty()) {
                JsonNode requestJson = JSON_MAPPER.readTree(body);
                if (requestJson.has("model")) {
                    String model = requestJson.get("model").asText();
                    metadata.put("model", model);
                }
                if (requestJson.has("messages")) {
                    String messagesJson = WrappedHttpClient.json(requestJson.get("messages"));
                    span.setAttribute("braintrust.input_json", messagesJson);
                }
            }
            span.setAttribute("braintrust.metadata", WrappedHttpClient.json(metadata));
        }
        catch (Exception e) {
            log.debug("Failed to parse request for span tagging", (Throwable)e);
        }
    }

    private static void tagSpan(Span span, SuccessfulHttpResponse response, ProviderInfo providerInfo, double timeToFirstToken) {
        try {
            HashMap<String, Number> metrics = new HashMap<String, Number>();
            metrics.put("time_to_first_token", timeToFirstToken);
            String body = response.body();
            if (body != null && !body.isEmpty()) {
                JsonNode responseJson = JSON_MAPPER.readTree(body);
                if (responseJson.has("choices")) {
                    String choicesJson = WrappedHttpClient.json(responseJson.get("choices"));
                    span.setAttribute("braintrust.output_json", choicesJson);
                }
                if (responseJson.has("usage")) {
                    JsonNode usage = responseJson.get("usage");
                    if (usage.has("prompt_tokens")) {
                        metrics.put("prompt_tokens", usage.get("prompt_tokens").asLong());
                    }
                    if (usage.has("completion_tokens")) {
                        metrics.put("completion_tokens", usage.get("completion_tokens").asLong());
                    }
                    if (usage.has("total_tokens")) {
                        metrics.put("tokens", usage.get("total_tokens").asLong());
                    }
                }
            }
            span.setAttribute("braintrust.metrics", WrappedHttpClient.json(metrics));
        }
        catch (Exception e) {
            log.debug("Failed to parse response for span tagging", (Throwable)e);
        }
    }

    private static void tagSpan(Span span, Throwable t) {
        span.setStatus(StatusCode.ERROR, t.getMessage());
        span.recordException(t);
    }

    private static String json(Object o) {
        return JSON_MAPPER.writeValueAsString(o);
    }

    private record ProviderInfo(String provider, String endpoint) {
    }

    private static class WrappedServerSentEventListener
    implements ServerSentEventListener {
        private final ServerSentEventListener delegate;
        private final Span span;
        private final ProviderInfo providerInfo;
        private final StringBuilder outputBuffer = new StringBuilder();
        private long firstTokenTime = 0L;
        private final long startTime;
        private JsonNode usageData = null;
        private String finishReason = null;

        WrappedServerSentEventListener(ServerSentEventListener delegate, Span span, ProviderInfo providerInfo) {
            this.delegate = delegate;
            this.span = span;
            this.providerInfo = providerInfo;
            this.startTime = System.nanoTime();
        }

        public void onOpen(SuccessfulHttpResponse response) {
            try (Scope ignored = this.span.makeCurrent();){
                this.delegate.onOpen(response);
            }
        }

        public void onEvent(ServerSentEvent event, ServerSentEventContext context) {
            try (Scope ignored = this.span.makeCurrent();){
                this.instrumentEvent(event);
                this.delegate.onEvent(event, context);
            }
        }

        public void onEvent(ServerSentEvent event) {
            try (Scope ignored = this.span.makeCurrent();){
                this.instrumentEvent(event);
                this.delegate.onEvent(event);
            }
        }

        private void instrumentEvent(ServerSentEvent event) {
            String data = event.data();
            if (data == null || data.isEmpty() || "[DONE]".equals(data)) {
                return;
            }
            if (this.firstTokenTime == 0L) {
                this.firstTokenTime = System.nanoTime();
            }
            try {
                JsonNode chunk = JSON_MAPPER.readTree(data);
                if (chunk.has("choices") && chunk.get("choices").size() > 0) {
                    JsonNode delta;
                    JsonNode choice = chunk.get("choices").get(0);
                    if (choice.has("delta") && (delta = choice.get("delta")).has("content")) {
                        String content = delta.get("content").asText();
                        this.outputBuffer.append(content);
                    }
                    if (choice.has("finish_reason") && !choice.get("finish_reason").isNull()) {
                        this.finishReason = choice.get("finish_reason").asText();
                    }
                }
                if (chunk.has("usage")) {
                    this.usageData = chunk.get("usage");
                }
            }
            catch (Exception e) {
                log.debug("Failed to parse streaming event: {}", (Object)data, (Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable error) {
            try (Scope ignored = this.span.makeCurrent();){
                this.delegate.onError(error);
            }
            finally {
                WrappedHttpClient.tagSpan(this.span, error);
                this.finalizeSpan();
                this.span.end();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose() {
            try (Scope ignored = this.span.makeCurrent();){
                this.delegate.onClose();
            }
            finally {
                this.finalizeSpan();
                this.span.end();
            }
        }

        private void finalizeSpan() {
            HashMap<String, Number> metrics = new HashMap<String, Number>();
            if (this.firstTokenTime > 0L) {
                double timeToFirstToken = (double)(this.firstTokenTime - this.startTime) / 1.0E9;
                metrics.put("time_to_first_token", timeToFirstToken);
            }
            if (this.outputBuffer.length() > 0 || this.finishReason != null) {
                try {
                    ObjectNode choiceBuilder = JSON_MAPPER.createObjectNode();
                    choiceBuilder.put("index", 0);
                    if (this.finishReason != null) {
                        choiceBuilder.put("finish_reason", this.finishReason);
                    }
                    ObjectNode messageNode = JSON_MAPPER.createObjectNode();
                    messageNode.put("role", "assistant");
                    messageNode.put("content", this.outputBuffer.toString());
                    choiceBuilder.set("message", (JsonNode)messageNode);
                    ArrayNode choicesArray = JSON_MAPPER.createArrayNode();
                    choicesArray.add((JsonNode)choiceBuilder);
                    this.span.setAttribute("braintrust.output_json", choicesArray.toString());
                }
                catch (Exception e) {
                    log.debug("Failed to reconstruct streaming output", (Throwable)e);
                }
            }
            if (this.usageData != null) {
                try {
                    if (this.usageData.has("prompt_tokens")) {
                        metrics.put("prompt_tokens", this.usageData.get("prompt_tokens").asLong());
                    }
                    if (this.usageData.has("completion_tokens")) {
                        metrics.put("completion_tokens", this.usageData.get("completion_tokens").asLong());
                    }
                    if (this.usageData.has("total_tokens")) {
                        metrics.put("tokens", this.usageData.get("total_tokens").asLong());
                    }
                }
                catch (Exception e) {
                    log.debug("Failed to extract usage metrics from streaming data", (Throwable)e);
                }
            }
            try {
                if (!metrics.isEmpty()) {
                    this.span.setAttribute("braintrust.metrics", WrappedHttpClient.json(metrics));
                }
            }
            catch (Exception e) {
                log.debug("Failed to serialize metrics", (Throwable)e);
            }
        }
    }
}

