/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai;

import com.openai.client.OpenAIClient;
import com.openai.core.ObjectMappers;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import dev.braintrust.instrumentation.openai.otel.OpenAITelemetry;
import dev.braintrust.prompt.BraintrustPrompt;
import io.opentelemetry.api.OpenTelemetry;
import java.util.HashMap;
import java.util.Map;

public class BraintrustOpenAI {
    public static OpenAIClient wrapOpenAI(OpenTelemetry openTelemetry, OpenAIClient openAIClient) {
        if ("true".equalsIgnoreCase(System.getenv("BRAINTRUST_X_OTEL_LOGS"))) {
            return io.opentelemetry.instrumentation.openai.v1_1.OpenAITelemetry.builder((OpenTelemetry)openTelemetry).setCaptureMessageContent(true).build().wrap(openAIClient);
        }
        return OpenAITelemetry.builder(openTelemetry).setCaptureMessageContent(true).build().wrap(openAIClient);
    }

    public static ChatCompletionCreateParams buildChatCompletionsPrompt(BraintrustPrompt prompt, Map<String, Object> parameters) {
        HashMap<String, Object> promptMap = new HashMap<String, Object>(prompt.getOptions());
        promptMap.put("messages", prompt.renderMessages(parameters));
        String promptJson = ObjectMappers.jsonMapper().writeValueAsString(promptMap);
        ChatCompletionCreateParams.Body body = (ChatCompletionCreateParams.Body)ObjectMappers.jsonMapper().readValue(promptJson, ChatCompletionCreateParams.Body.class);
        return ChatCompletionCreateParams.builder().body(body).additionalBodyProperties(Map.of()).build();
    }
}

