/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.openai.models.ChatModel;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import dev.braintrust.instrumentation.openai.otel.GenAiSemconvSerializer;
import io.opentelemetry.api.trace.Span;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BraintrustOAISpanAttributes {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustOAISpanAttributes.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    static final String OPERATION_CHAT = "chat";
    static final String OPERATION_EMBEDDINGS = "embeddings";
    static final String SYSTEM_OPENAI = "openai";

    private BraintrustOAISpanAttributes() {
    }

    static void setRequestAttributes(Span span, ChatCompletionCreateParams request) {
        String semconvJson = GenAiSemconvSerializer.serializeInputMessages(request.messages());
        span.setAttribute("gen_ai.input.messages", semconvJson);
        span.setAttribute("braintrust.metadata.provider", SYSTEM_OPENAI);
        try {
            ChatModel model = request.model();
            span.setAttribute("braintrust.metadata.model", model.toString());
        }
        catch (Exception e) {
            log.debug("Could not get model from request", (Throwable)e);
        }
    }

    static void setOutputMessagesFromCompletion(Span span, ChatCompletion completion) {
        span.setAttribute("gen_ai.output.messages", GenAiSemconvSerializer.serializeOutputMessages(completion.choices()));
    }

    static void setTimeToFirstToken(Span span, double timeInSeconds) {
        span.setAttribute("braintrust.metrics.time_to_first_token", timeInSeconds);
    }
}

