/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.completions.CompletionUsage;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

enum ChatAttributesGetter implements GenAiAttributesGetter<ChatCompletionCreateParams, ChatCompletion>
{
    INSTANCE;


    public String getOperationName(ChatCompletionCreateParams request) {
        return "chat";
    }

    public String getSystem(ChatCompletionCreateParams request) {
        return "openai";
    }

    public String getRequestModel(ChatCompletionCreateParams request) {
        return request.model().asString();
    }

    @Nullable
    public Long getRequestSeed(ChatCompletionCreateParams request) {
        return request.seed().orElse(null);
    }

    @Nullable
    public List<String> getRequestEncodingFormats(ChatCompletionCreateParams request) {
        return null;
    }

    @Nullable
    public Double getRequestFrequencyPenalty(ChatCompletionCreateParams request) {
        return request.frequencyPenalty().orElse(null);
    }

    @Nullable
    public Long getRequestMaxTokens(ChatCompletionCreateParams request) {
        return request.maxCompletionTokens().orElse(null);
    }

    @Nullable
    public Double getRequestPresencePenalty(ChatCompletionCreateParams request) {
        return request.presencePenalty().orElse(null);
    }

    @Nullable
    public List<String> getRequestStopSequences(ChatCompletionCreateParams request) {
        return request.stop().map(s -> {
            if (s.isString()) {
                return Collections.singletonList(s.asString());
            }
            if (s.isStrings()) {
                return s.asStrings();
            }
            return null;
        }).orElse(null);
    }

    @Nullable
    public Double getRequestTemperature(ChatCompletionCreateParams request) {
        return request.temperature().orElse(null);
    }

    @Nullable
    public Double getRequestTopK(ChatCompletionCreateParams request) {
        return null;
    }

    @Nullable
    public Double getRequestTopP(ChatCompletionCreateParams request) {
        return request.topP().orElse(null);
    }

    public List<String> getResponseFinishReasons(ChatCompletionCreateParams request, @Nullable ChatCompletion response) {
        if (response == null) {
            return Collections.emptyList();
        }
        return response.choices().stream().map(choice -> choice.finishReason().asString()).collect(Collectors.toList());
    }

    @Nullable
    public String getResponseId(ChatCompletionCreateParams request, @Nullable ChatCompletion response) {
        if (response == null) {
            return null;
        }
        return response.id();
    }

    @Nullable
    public String getResponseModel(ChatCompletionCreateParams request, @Nullable ChatCompletion response) {
        if (response == null) {
            return null;
        }
        return response.model();
    }

    @Nullable
    public Long getUsageInputTokens(ChatCompletionCreateParams request, @Nullable ChatCompletion response) {
        if (response == null) {
            return null;
        }
        return response.usage().map(CompletionUsage::promptTokens).orElse(null);
    }

    @Nullable
    public Long getUsageOutputTokens(ChatCompletionCreateParams request, @Nullable ChatCompletion response) {
        if (response == null) {
            return null;
        }
        return response.usage().map(CompletionUsage::completionTokens).orElse(null);
    }
}

