/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.models.embeddings.CreateEmbeddingResponse;
import com.openai.models.embeddings.EmbeddingCreateParams;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

enum EmbeddingAttributesGetter implements GenAiAttributesGetter<EmbeddingCreateParams, CreateEmbeddingResponse>
{
    INSTANCE;


    public String getOperationName(EmbeddingCreateParams request) {
        return "embeddings";
    }

    public String getSystem(EmbeddingCreateParams request) {
        return "openai";
    }

    public String getRequestModel(EmbeddingCreateParams request) {
        return request.model().asString();
    }

    @Nullable
    public Long getRequestSeed(EmbeddingCreateParams request) {
        return null;
    }

    @Nullable
    public List<String> getRequestEncodingFormats(EmbeddingCreateParams request) {
        return request.encodingFormat().map(f -> Collections.singletonList(f.asString())).orElse(null);
    }

    @Nullable
    public Double getRequestFrequencyPenalty(EmbeddingCreateParams request) {
        return null;
    }

    @Nullable
    public Long getRequestMaxTokens(EmbeddingCreateParams request) {
        return null;
    }

    @Nullable
    public Double getRequestPresencePenalty(EmbeddingCreateParams request) {
        return null;
    }

    @Nullable
    public List<String> getRequestStopSequences(EmbeddingCreateParams request) {
        return null;
    }

    @Nullable
    public Double getRequestTemperature(EmbeddingCreateParams request) {
        return null;
    }

    @Nullable
    public Double getRequestTopK(EmbeddingCreateParams request) {
        return null;
    }

    @Nullable
    public Double getRequestTopP(EmbeddingCreateParams request) {
        return null;
    }

    public List<String> getResponseFinishReasons(EmbeddingCreateParams request, @Nullable CreateEmbeddingResponse response) {
        return Collections.emptyList();
    }

    @Nullable
    public String getResponseId(EmbeddingCreateParams request, @Nullable CreateEmbeddingResponse response) {
        return null;
    }

    @Nullable
    public String getResponseModel(EmbeddingCreateParams request, @Nullable CreateEmbeddingResponse response) {
        if (response == null) {
            return null;
        }
        return response.model();
    }

    @Nullable
    public Long getUsageInputTokens(EmbeddingCreateParams request, @Nullable CreateEmbeddingResponse response) {
        if (response == null) {
            return null;
        }
        return response.usage().promptTokens();
    }

    @Nullable
    public Long getUsageOutputTokens(EmbeddingCreateParams request, @Nullable CreateEmbeddingResponse response) {
        return null;
    }
}

