/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionAssistantMessageParam;
import com.openai.models.chat.completions.ChatCompletionContentPart;
import com.openai.models.chat.completions.ChatCompletionContentPartImage;
import com.openai.models.chat.completions.ChatCompletionContentPartText;
import com.openai.models.chat.completions.ChatCompletionDeveloperMessageParam;
import com.openai.models.chat.completions.ChatCompletionMessage;
import com.openai.models.chat.completions.ChatCompletionMessageParam;
import com.openai.models.chat.completions.ChatCompletionMessageToolCall;
import com.openai.models.chat.completions.ChatCompletionSystemMessageParam;
import com.openai.models.chat.completions.ChatCompletionToolMessageParam;
import com.openai.models.chat.completions.ChatCompletionUserMessageParam;
import dev.braintrust.trace.Base64Attachment;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GenAiSemconvSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenAiSemconvSerializer.class);
    private static final ObjectMapper JSON_MAPPER = GenAiSemconvSerializer.createObjectMapper();

    private static ObjectMapper createObjectMapper() {
        final JsonSerializer<Base64Attachment> attachmentSerializer = Base64Attachment.createSerializer();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule();
        module.addSerializer(ChatCompletionContentPartImage.class, (JsonSerializer)new JsonSerializer<ChatCompletionContentPartImage>(){

            public void serialize(ChatCompletionContentPartImage value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                try {
                    Base64Attachment attachment = Base64Attachment.of(value.validate().imageUrl().validate().url());
                    attachmentSerializer.serialize((Object)attachment, gen, serializers);
                }
                catch (Exception e) {
                    JsonSerializer defaultSerializer = serializers.findValueSerializer(ChatCompletionContentPartImage.class, null);
                    defaultSerializer.serialize((Object)value, gen, serializers);
                }
            }
        });
        mapper.registerModule((Module)module);
        return mapper;
    }

    static List<SemconvChatMessage> transformToSemconvMessages(List<ChatCompletionMessageParam> messages) {
        return messages.stream().map(GenAiSemconvSerializer::transformMessage).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static SemconvChatMessage transformMessage(ChatCompletionMessageParam message) {
        Optional<ChatCompletionUserMessageParam> userOpt = GenAiSemconvSerializer.tryGetUser(message);
        if (userOpt.isPresent()) {
            return GenAiSemconvSerializer.transformUserMessage(userOpt.get());
        }
        Optional<ChatCompletionSystemMessageParam> systemOpt = GenAiSemconvSerializer.tryGetSystem(message);
        if (systemOpt.isPresent()) {
            return GenAiSemconvSerializer.transformSystemMessage(systemOpt.get());
        }
        Optional<ChatCompletionAssistantMessageParam> assistantOpt = GenAiSemconvSerializer.tryGetAssistant(message);
        if (assistantOpt.isPresent()) {
            return GenAiSemconvSerializer.transformAssistantMessage(assistantOpt.get());
        }
        Optional<ChatCompletionToolMessageParam> toolOpt = GenAiSemconvSerializer.tryGetTool(message);
        if (toolOpt.isPresent()) {
            return GenAiSemconvSerializer.transformToolMessage(toolOpt.get());
        }
        Optional<ChatCompletionDeveloperMessageParam> developerOpt = GenAiSemconvSerializer.tryGetDeveloper(message);
        if (developerOpt.isPresent()) {
            return GenAiSemconvSerializer.transformDeveloperMessage(developerOpt.get());
        }
        return null;
    }

    private static Optional<ChatCompletionUserMessageParam> tryGetUser(ChatCompletionMessageParam message) {
        try {
            Method method = message.getClass().getMethod("user", new Class[0]);
            Optional result = (Optional)method.invoke((Object)message, new Object[0]);
            return result;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<ChatCompletionSystemMessageParam> tryGetSystem(ChatCompletionMessageParam message) {
        try {
            Method method = message.getClass().getMethod("system", new Class[0]);
            Optional result = (Optional)method.invoke((Object)message, new Object[0]);
            return result;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<ChatCompletionAssistantMessageParam> tryGetAssistant(ChatCompletionMessageParam message) {
        try {
            Method method = message.getClass().getMethod("assistant", new Class[0]);
            Optional result = (Optional)method.invoke((Object)message, new Object[0]);
            return result;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<ChatCompletionToolMessageParam> tryGetTool(ChatCompletionMessageParam message) {
        try {
            Method method = message.getClass().getMethod("tool", new Class[0]);
            Optional result = (Optional)method.invoke((Object)message, new Object[0]);
            return result;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<ChatCompletionDeveloperMessageParam> tryGetDeveloper(ChatCompletionMessageParam message) {
        try {
            Method method = message.getClass().getMethod("developer", new Class[0]);
            Optional result = (Optional)method.invoke((Object)message, new Object[0]);
            return result;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static SemconvChatMessage transformUserMessage(ChatCompletionUserMessageParam message) {
        ArrayList<Object> parts = new ArrayList<Object>();
        ChatCompletionUserMessageParam.Content content = message.content();
        if (content.isText()) {
            parts.add(new TextPart(content.asText()));
        } else if (content.isArrayOfContentParts()) {
            for (ChatCompletionContentPart part : content.asArrayOfContentParts()) {
                if (part.isText()) {
                    parts.add(new TextPart(part.asText().text()));
                    continue;
                }
                Optional<ChatCompletionContentPartImage> imageOpt = GenAiSemconvSerializer.tryGetImagePart(part);
                if (!imageOpt.isPresent()) continue;
                try {
                    String imageUrl = imageOpt.get().imageUrl().url();
                    Base64Attachment attachment = Base64Attachment.of(imageUrl);
                    parts.add(attachment);
                }
                catch (Exception e) {
                    log.debug("Failed to parse image URL", (Throwable)e);
                }
            }
        }
        return new SemconvChatMessage("user", parts);
    }

    private static Optional<ChatCompletionContentPartImage> tryGetImagePart(ChatCompletionContentPart part) {
        try {
            Method method = part.getClass().getMethod("imageUrl", new Class[0]);
            Optional result = (Optional)method.invoke((Object)part, new Object[0]);
            return result;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static SemconvChatMessage transformSystemMessage(ChatCompletionSystemMessageParam message) {
        ArrayList<Object> parts = new ArrayList<Object>();
        ChatCompletionSystemMessageParam.Content content = message.content();
        if (content.isText()) {
            parts.add(new TextPart(content.asText()));
        } else if (content.isArrayOfContentParts()) {
            for (ChatCompletionContentPartText part : content.asArrayOfContentParts()) {
                parts.add(new TextPart(part.text()));
            }
        }
        return new SemconvChatMessage("system", parts);
    }

    private static SemconvChatMessage transformDeveloperMessage(ChatCompletionDeveloperMessageParam message) {
        ArrayList<Object> parts = new ArrayList<Object>();
        ChatCompletionDeveloperMessageParam.Content content = message.content();
        if (content.isText()) {
            parts.add(new TextPart(content.asText()));
        } else if (content.isArrayOfContentParts()) {
            for (ChatCompletionContentPartText part : content.asArrayOfContentParts()) {
                parts.add(new TextPart(part.text()));
            }
        }
        return new SemconvChatMessage("system", parts);
    }

    private static SemconvChatMessage transformAssistantMessage(ChatCompletionAssistantMessageParam message) {
        ArrayList<Object> parts = new ArrayList<Object>();
        message.content().ifPresent(content -> {
            if (content.isText()) {
                parts.add(new TextPart(content.asText()));
            } else if (content.isArrayOfContentParts()) {
                for (ChatCompletionAssistantMessageParam.Content.ChatCompletionRequestAssistantMessageContentPart part : content.asArrayOfContentParts()) {
                    if (part.isText()) {
                        parts.add(new TextPart(part.asText().text()));
                        continue;
                    }
                    if (!part.isRefusal()) continue;
                    parts.add(new TextPart(part.asRefusal().refusal()));
                }
            }
        });
        message.toolCalls().ifPresent(toolCalls -> {
            for (ChatCompletionMessageToolCall toolCall : toolCalls) {
                FunctionAccess functionAccess = GenAiSemconvSerializer.getFunctionAccess(toolCall);
                if (functionAccess == null) continue;
                parts.add(new ToolCallRequestPart(functionAccess.name(), functionAccess.id(), functionAccess.arguments()));
            }
        });
        return new SemconvChatMessage("assistant", parts);
    }

    private static SemconvChatMessage transformToolMessage(ChatCompletionToolMessageParam message) {
        ArrayList<Object> parts = new ArrayList<Object>();
        String toolCallId = message.toolCallId();
        ChatCompletionToolMessageParam.Content content = message.content();
        String responseContent = "";
        if (content.isText()) {
            responseContent = content.asText();
        } else if (content.isArrayOfContentParts()) {
            responseContent = GenAiSemconvSerializer.joinContentParts(content.asArrayOfContentParts());
        }
        parts.add(new ToolCallResponsePart(toolCallId, responseContent));
        return new SemconvChatMessage("tool", parts);
    }

    static SemconvOutputChatMessage transformOutputMessage(ChatCompletionMessage message, String finishReason) {
        ArrayList<Object> parts = new ArrayList<Object>();
        message.content().ifPresent(content -> {
            if (!content.isEmpty()) {
                parts.add(new TextPart((String)content));
            }
        });
        message.toolCalls().ifPresent(toolCalls -> {
            for (ChatCompletionMessageToolCall toolCall : toolCalls) {
                FunctionAccess functionAccess = GenAiSemconvSerializer.getFunctionAccess(toolCall);
                if (functionAccess == null) continue;
                parts.add(new ToolCallRequestPart(functionAccess.name(), functionAccess.id(), functionAccess.arguments()));
            }
        });
        return new SemconvOutputChatMessage("assistant", parts, finishReason);
    }

    private static String joinContentParts(List<ChatCompletionContentPartText> contentParts) {
        return contentParts.stream().map(ChatCompletionContentPartText::text).collect(Collectors.joining());
    }

    static String serializeInputMessages(List<ChatCompletionMessageParam> messages) {
        List<SemconvChatMessage> semconvMessages = GenAiSemconvSerializer.transformToSemconvMessages(messages);
        return JSON_MAPPER.writeValueAsString(semconvMessages);
    }

    static String serializeOutputMessages(List<ChatCompletion.Choice> choices) {
        List<SemconvOutputChatMessage> semConvMessages = choices.stream().map(c -> GenAiSemconvSerializer.transformOutputMessage(c.message(), c.finishReason().toString())).toList();
        return JSON_MAPPER.writeValueAsString(semConvMessages);
    }

    @Nullable
    static FunctionAccess getFunctionAccess(ChatCompletionMessageToolCall call) {
        if (V1FunctionAccess.isAvailable()) {
            return V1FunctionAccess.create(call);
        }
        if (V3FunctionAccess.isAvailable()) {
            return V3FunctionAccess.create(call);
        }
        return null;
    }

    private static String invokeStringHandle(@Nullable MethodHandle methodHandle, Object object) {
        if (methodHandle == null) {
            return "";
        }
        try {
            return methodHandle.invoke(object);
        }
        catch (Throwable ignore) {
            return "";
        }
    }

    private GenAiSemconvSerializer() {
    }

    static class SemconvChatMessage {
        @JsonProperty(value="role")
        public final String role;
        @JsonProperty(value="parts")
        public final List<Object> parts;

        public SemconvChatMessage(String role, List<Object> parts) {
            this.role = role;
            this.parts = parts;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class TextPart {
        @JsonProperty(value="type")
        public final String type = "text";
        @JsonProperty(value="content")
        public final String content;

        public TextPart(String content) {
            this.content = content;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class ToolCallResponsePart {
        @JsonProperty(value="type")
        public final String type = "tool_call_response";
        @JsonProperty(value="id")
        public final String id;
        @JsonProperty(value="response")
        public final String response;

        public ToolCallResponsePart(String id, String response) {
            this.id = id;
            this.response = response;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class SemconvOutputChatMessage {
        @JsonProperty(value="role")
        public final String role;
        @JsonProperty(value="parts")
        public final List<Object> parts;
        @JsonProperty(value="finish_reason")
        public final String finishReason;

        public SemconvOutputChatMessage(String role, List<Object> parts, String finishReason) {
            this.role = role;
            this.parts = parts;
            this.finishReason = finishReason;
        }
    }

    private static class V1FunctionAccess
    implements FunctionAccess {
        @Nullable
        private static final MethodHandle idHandle;
        @Nullable
        private static final MethodHandle functionHandle;
        @Nullable
        private static final MethodHandle nameHandle;
        @Nullable
        private static final MethodHandle argumentsHandle;
        private final ChatCompletionMessageToolCall toolCall;
        private final Object function;

        V1FunctionAccess(ChatCompletionMessageToolCall toolCall, Object function) {
            this.toolCall = toolCall;
            this.function = function;
        }

        @Nullable
        static FunctionAccess create(ChatCompletionMessageToolCall toolCall) {
            if (functionHandle == null) {
                return null;
            }
            try {
                return new V1FunctionAccess(toolCall, functionHandle.invoke(toolCall));
            }
            catch (Throwable ignore) {
                return null;
            }
        }

        static boolean isAvailable() {
            return idHandle != null;
        }

        @Override
        public String id() {
            return GenAiSemconvSerializer.invokeStringHandle(idHandle, this.toolCall);
        }

        @Override
        public String name() {
            return GenAiSemconvSerializer.invokeStringHandle(nameHandle, this.function);
        }

        @Override
        public String arguments() {
            return GenAiSemconvSerializer.invokeStringHandle(argumentsHandle, this.function);
        }

        static {
            MethodHandle arguments;
            MethodHandle name;
            MethodHandle function;
            MethodHandle id;
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                id = lookup.findVirtual(ChatCompletionMessageToolCall.class, "id", MethodType.methodType(String.class));
                Class<?> functionClass = Class.forName("com.openai.models.chat.completions.ChatCompletionMessageToolCall$Function");
                function = lookup.findVirtual(ChatCompletionMessageToolCall.class, "function", MethodType.methodType(functionClass));
                name = lookup.findVirtual(functionClass, "name", MethodType.methodType(String.class));
                arguments = lookup.findVirtual(functionClass, "arguments", MethodType.methodType(String.class));
            }
            catch (Exception exception) {
                id = null;
                function = null;
                name = null;
                arguments = null;
            }
            idHandle = id;
            functionHandle = function;
            nameHandle = name;
            argumentsHandle = arguments;
        }
    }

    static interface FunctionAccess {
        public String id();

        public String name();

        public String arguments();
    }

    static class V3FunctionAccess
    implements FunctionAccess {
        @Nullable
        private static final MethodHandle functionToolCallHandle;
        @Nullable
        private static final MethodHandle idHandle;
        @Nullable
        private static final MethodHandle functionHandle;
        @Nullable
        private static final MethodHandle nameHandle;
        @Nullable
        private static final MethodHandle argumentsHandle;
        private final Object functionToolCall;
        private final Object function;

        V3FunctionAccess(Object functionToolCall, Object function) {
            this.functionToolCall = functionToolCall;
            this.function = function;
        }

        @Nullable
        static FunctionAccess create(ChatCompletionMessageToolCall toolCall) {
            if (functionToolCallHandle == null || functionHandle == null) {
                return null;
            }
            try {
                Optional optional = functionToolCallHandle.invoke(toolCall);
                if (!optional.isPresent()) {
                    return null;
                }
                Object functionToolCall = optional.get();
                return new V3FunctionAccess(functionToolCall, functionHandle.invoke(functionToolCall));
            }
            catch (Throwable ignore) {
                return null;
            }
        }

        static boolean isAvailable() {
            return idHandle != null;
        }

        @Override
        public String id() {
            return GenAiSemconvSerializer.invokeStringHandle(idHandle, this.functionToolCall);
        }

        @Override
        public String name() {
            return GenAiSemconvSerializer.invokeStringHandle(nameHandle, this.function);
        }

        @Override
        public String arguments() {
            return GenAiSemconvSerializer.invokeStringHandle(argumentsHandle, this.function);
        }

        static {
            MethodHandle arguments;
            MethodHandle name;
            MethodHandle function;
            MethodHandle id;
            MethodHandle functionToolCall;
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                functionToolCall = lookup.findVirtual(ChatCompletionMessageToolCall.class, "function", MethodType.methodType(Optional.class));
                Class<?> functionToolCallClass = Class.forName("com.openai.models.chat.completions.ChatCompletionMessageFunctionToolCall");
                id = lookup.findVirtual(functionToolCallClass, "id", MethodType.methodType(String.class));
                Class<?> functionClass = Class.forName("com.openai.models.chat.completions.ChatCompletionMessageFunctionToolCall$Function");
                function = lookup.findVirtual(functionToolCallClass, "function", MethodType.methodType(functionClass));
                name = lookup.findVirtual(functionClass, "name", MethodType.methodType(String.class));
                arguments = lookup.findVirtual(functionClass, "arguments", MethodType.methodType(String.class));
            }
            catch (Exception exception) {
                functionToolCall = null;
                id = null;
                function = null;
                name = null;
                arguments = null;
            }
            functionToolCallHandle = functionToolCall;
            idHandle = id;
            functionHandle = function;
            nameHandle = name;
            argumentsHandle = arguments;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class ToolCallRequestPart {
        @JsonProperty(value="type")
        public final String type = "tool_call";
        @JsonProperty(value="name")
        public final String name;
        @JsonProperty(value="id")
        public final String id;
        @JsonProperty(value="arguments")
        public final String arguments;

        public ToolCallRequestPart(String name, String id, String arguments) {
            this.name = name;
            this.id = id;
            this.arguments = arguments;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class GenericPart {
        @JsonProperty(value="type")
        public final String type;
        @JsonProperty(value="data")
        public final Object data;

        public GenericPart(String type, Object data) {
            this.type = type;
            this.data = data;
        }
    }
}

