/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.core.RequestOptions;
import com.openai.core.http.StreamResponse;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionChunk;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.services.blocking.chat.ChatCompletionService;
import dev.braintrust.instrumentation.openai.otel.BraintrustOAISpanAttributes;
import dev.braintrust.instrumentation.openai.otel.DelegatingInvocationHandler;
import dev.braintrust.instrumentation.openai.otel.StreamListener;
import dev.braintrust.instrumentation.openai.otel.TracingStreamedResponse;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.lang.reflect.Method;

final class InstrumentedChatCompletionService
extends DelegatingInvocationHandler<ChatCompletionService, InstrumentedChatCompletionService> {
    private final Instrumenter<ChatCompletionCreateParams, ChatCompletion> instrumenter;
    private final boolean captureMessageContent;

    InstrumentedChatCompletionService(ChatCompletionService delegate, Instrumenter<ChatCompletionCreateParams, ChatCompletion> instrumenter, boolean captureMessageContent) {
        super(delegate);
        this.instrumenter = instrumenter;
        this.captureMessageContent = captureMessageContent;
    }

    @Override
    protected Class<ChatCompletionService> getProxyType() {
        return ChatCompletionService.class;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        switch (methodName) {
            case "create": {
                if (parameterTypes.length < 1 || parameterTypes[0] != ChatCompletionCreateParams.class) break;
                if (parameterTypes.length == 1) {
                    return this.create((ChatCompletionCreateParams)args[0], RequestOptions.none());
                }
                if (parameterTypes.length != 2 || parameterTypes[1] != RequestOptions.class) break;
                return this.create((ChatCompletionCreateParams)args[0], (RequestOptions)args[1]);
            }
            case "createStreaming": {
                if (parameterTypes.length < 1 || parameterTypes[0] != ChatCompletionCreateParams.class) break;
                if (parameterTypes.length == 1) {
                    return this.createStreaming((ChatCompletionCreateParams)args[0], RequestOptions.none());
                }
                if (parameterTypes.length != 2 || parameterTypes[1] != RequestOptions.class) break;
                return this.createStreaming((ChatCompletionCreateParams)args[0], (RequestOptions)args[1]);
            }
        }
        return super.invoke(proxy, method, args);
    }

    private ChatCompletion create(ChatCompletionCreateParams chatCompletionCreateParams, RequestOptions requestOptions) {
        ChatCompletion completion;
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)chatCompletionCreateParams)) {
            return this.createWithAttributes(parentContext, chatCompletionCreateParams, requestOptions);
        }
        Context context = this.instrumenter.start(parentContext, (Object)chatCompletionCreateParams);
        try (Scope ignored = context.makeCurrent();){
            completion = this.createWithAttributes(context, chatCompletionCreateParams, requestOptions);
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)chatCompletionCreateParams, null, t);
            throw t;
        }
        this.instrumenter.end(context, (Object)chatCompletionCreateParams, (Object)completion, null);
        return completion;
    }

    private ChatCompletion createWithAttributes(Context context, ChatCompletionCreateParams chatCompletionCreateParams, RequestOptions requestOptions) {
        BraintrustOAISpanAttributes.setRequestAttributes(Span.current(), chatCompletionCreateParams);
        long startTimeNanos = System.nanoTime();
        ChatCompletion result = ((ChatCompletionService)this.delegate).create(chatCompletionCreateParams, requestOptions);
        long elapsedNanos = System.nanoTime() - startTimeNanos;
        double timeToFirstTokenSeconds = (double)elapsedNanos / 1.0E9;
        BraintrustOAISpanAttributes.setTimeToFirstToken(Span.current(), timeToFirstTokenSeconds);
        BraintrustOAISpanAttributes.setOutputMessagesFromCompletion(Span.current(), result);
        return result;
    }

    private StreamResponse<ChatCompletionChunk> createStreaming(ChatCompletionCreateParams chatCompletionCreateParams, RequestOptions requestOptions) {
        StreamResponse<ChatCompletionChunk> streamResponse;
        block9: {
            Context parentContext = Context.current();
            if (!this.instrumenter.shouldStart(parentContext, (Object)chatCompletionCreateParams)) {
                return this.createStreamingWithAttributes(parentContext, chatCompletionCreateParams, requestOptions, false);
            }
            Context context = this.instrumenter.start(parentContext, (Object)chatCompletionCreateParams);
            Scope ignored = context.makeCurrent();
            try {
                streamResponse = this.createStreamingWithAttributes(context, chatCompletionCreateParams, requestOptions, true);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.instrumenter.end(context, (Object)chatCompletionCreateParams, null, t);
                    throw t;
                }
            }
            ignored.close();
        }
        return streamResponse;
    }

    private StreamResponse<ChatCompletionChunk> createStreamingWithAttributes(Context context, ChatCompletionCreateParams chatCompletionCreateParams, RequestOptions requestOptions, boolean newSpan) {
        BraintrustOAISpanAttributes.setRequestAttributes(Span.current(), chatCompletionCreateParams);
        long startTimeNanos = System.nanoTime();
        StreamResponse result = ((ChatCompletionService)this.delegate).createStreaming(chatCompletionCreateParams, requestOptions);
        return new TracingStreamedResponse((StreamResponse<ChatCompletionChunk>)result, new StreamListener(context, chatCompletionCreateParams, this.instrumenter, this.captureMessageContent, newSpan, startTimeNanos));
    }
}

