/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.core.RequestOptions;
import com.openai.models.embeddings.CreateEmbeddingResponse;
import com.openai.models.embeddings.EmbeddingCreateParams;
import com.openai.services.blocking.EmbeddingService;
import dev.braintrust.instrumentation.openai.otel.DelegatingInvocationHandler;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.lang.reflect.Method;

final class InstrumentedEmbeddingService
extends DelegatingInvocationHandler<EmbeddingService, InstrumentedEmbeddingService> {
    private final Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> instrumenter;

    public InstrumentedEmbeddingService(EmbeddingService delegate, Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> instrumenter) {
        super(delegate);
        this.instrumenter = instrumenter;
    }

    @Override
    protected Class<EmbeddingService> getProxyType() {
        return EmbeddingService.class;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (methodName.equals("create") && parameterTypes.length >= 1 && parameterTypes[0] == EmbeddingCreateParams.class) {
            if (parameterTypes.length == 1) {
                return this.create((EmbeddingCreateParams)args[0], RequestOptions.none());
            }
            if (parameterTypes.length == 2 && parameterTypes[1] == RequestOptions.class) {
                return this.create((EmbeddingCreateParams)args[0], (RequestOptions)args[1]);
            }
        }
        return super.invoke(proxy, method, args);
    }

    private CreateEmbeddingResponse create(EmbeddingCreateParams request, RequestOptions requestOptions) {
        CreateEmbeddingResponse response;
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            return ((EmbeddingService)this.delegate).create(request, requestOptions);
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        try (Scope ignored = context.makeCurrent();){
            response = ((EmbeddingService)this.delegate).create(request, requestOptions);
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)request, null, t);
            throw t;
        }
        this.instrumenter.end(context, (Object)request, (Object)response, null);
        return response;
    }
}

