/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.core.RequestOptions;
import com.openai.models.embeddings.CreateEmbeddingResponse;
import com.openai.models.embeddings.EmbeddingCreateParams;
import com.openai.services.async.EmbeddingServiceAsync;
import dev.braintrust.instrumentation.openai.otel.CompletableFutureWrapper;
import dev.braintrust.instrumentation.openai.otel.DelegatingInvocationHandler;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class InstrumentedEmbeddingServiceAsync
extends DelegatingInvocationHandler<EmbeddingServiceAsync, InstrumentedEmbeddingServiceAsync> {
    private final Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> instrumenter;

    public InstrumentedEmbeddingServiceAsync(EmbeddingServiceAsync delegate, Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> instrumenter) {
        super(delegate);
        this.instrumenter = instrumenter;
    }

    @Override
    protected Class<EmbeddingServiceAsync> getProxyType() {
        return EmbeddingServiceAsync.class;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (methodName.equals("create") && parameterTypes.length >= 1 && parameterTypes[0] == EmbeddingCreateParams.class) {
            if (parameterTypes.length == 1) {
                return this.create((EmbeddingCreateParams)args[0], RequestOptions.none());
            }
            if (parameterTypes.length == 2 && parameterTypes[1] == RequestOptions.class) {
                return this.create((EmbeddingCreateParams)args[0], (RequestOptions)args[1]);
            }
        }
        return super.invoke(proxy, method, args);
    }

    private CompletableFuture<CreateEmbeddingResponse> create(EmbeddingCreateParams request, RequestOptions requestOptions) {
        CompletionStage future;
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            return ((EmbeddingServiceAsync)this.delegate).create(request, requestOptions);
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        try (Scope ignored = context.makeCurrent();){
            future = ((EmbeddingServiceAsync)this.delegate).create(request, requestOptions);
        }
        catch (Throwable t2) {
            this.instrumenter.end(context, (Object)request, null, t2);
            throw t2;
        }
        future = future.whenComplete((res, t) -> this.instrumenter.end(context, (Object)request, res, t));
        return CompletableFutureWrapper.wrap(future, parentContext);
    }
}

