/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.client.OpenAIClient;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.embeddings.CreateEmbeddingResponse;
import com.openai.models.embeddings.EmbeddingCreateParams;
import com.openai.services.blocking.ChatService;
import dev.braintrust.instrumentation.openai.otel.DelegatingInvocationHandler;
import dev.braintrust.instrumentation.openai.otel.InstrumentedChatCompletionService;
import dev.braintrust.instrumentation.openai.otel.InstrumentedEmbeddingService;
import dev.braintrust.instrumentation.openai.otel.InstrumentedOpenAiClientAsync;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

final class InstrumentedOpenAiClient
extends DelegatingInvocationHandler<OpenAIClient, InstrumentedOpenAiClient> {
    private final Instrumenter<ChatCompletionCreateParams, ChatCompletion> chatInstrumenter;
    private final Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> embeddingInstrumenter;
    private final boolean captureMessageContent;

    InstrumentedOpenAiClient(OpenAIClient delegate, Instrumenter<ChatCompletionCreateParams, ChatCompletion> chatInstrumenter, Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> embeddingInstrumenter, boolean captureMessageContent) {
        super(delegate);
        this.chatInstrumenter = chatInstrumenter;
        this.embeddingInstrumenter = embeddingInstrumenter;
        this.captureMessageContent = captureMessageContent;
    }

    @Override
    protected Class<OpenAIClient> getProxyType() {
        return OpenAIClient.class;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (methodName.equals("chat") && parameterTypes.length == 0) {
            return this.createChatServiceProxy();
        }
        if (methodName.equals("embeddings") && parameterTypes.length == 0) {
            return new InstrumentedEmbeddingService(((OpenAIClient)this.delegate).embeddings(), this.embeddingInstrumenter).createProxy();
        }
        if (methodName.equals("async") && parameterTypes.length == 0) {
            return new InstrumentedOpenAiClientAsync(((OpenAIClient)this.delegate).async(), this.chatInstrumenter, this.embeddingInstrumenter, this.captureMessageContent).createProxy();
        }
        return super.invoke(proxy, method, args);
    }

    private Object createChatServiceProxy() {
        return Proxy.newProxyInstance(ChatService.class.getClassLoader(), new Class[]{ChatService.class}, (p, m, a) -> {
            if ("completions".equals(m.getName()) && m.getParameterCount() == 0) {
                return new InstrumentedChatCompletionService(((OpenAIClient)this.delegate).chat().completions(), this.chatInstrumenter, this.captureMessageContent).createProxy();
            }
            return m.invoke((Object)((OpenAIClient)this.delegate).chat(), a);
        });
    }
}

