/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.client.OpenAIClientAsync;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.embeddings.CreateEmbeddingResponse;
import com.openai.models.embeddings.EmbeddingCreateParams;
import com.openai.services.async.ChatServiceAsync;
import dev.braintrust.instrumentation.openai.otel.DelegatingInvocationHandler;
import dev.braintrust.instrumentation.openai.otel.InstrumentedChatCompletionServiceAsync;
import dev.braintrust.instrumentation.openai.otel.InstrumentedEmbeddingServiceAsync;
import dev.braintrust.instrumentation.openai.otel.InstrumentedOpenAiClient;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

final class InstrumentedOpenAiClientAsync
extends DelegatingInvocationHandler<OpenAIClientAsync, InstrumentedOpenAiClientAsync> {
    private final Instrumenter<ChatCompletionCreateParams, ChatCompletion> chatInstrumenter;
    private final Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> embeddingInstrumenter;
    private final boolean captureMessageContent;

    InstrumentedOpenAiClientAsync(OpenAIClientAsync delegate, Instrumenter<ChatCompletionCreateParams, ChatCompletion> chatInstrumenter, Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> embeddingInstrumenter, boolean captureMessageContent) {
        super(delegate);
        this.chatInstrumenter = chatInstrumenter;
        this.embeddingInstrumenter = embeddingInstrumenter;
        this.captureMessageContent = captureMessageContent;
    }

    @Override
    protected Class<OpenAIClientAsync> getProxyType() {
        return OpenAIClientAsync.class;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (methodName.equals("chat") && parameterTypes.length == 0) {
            return this.createChatServiceAsyncProxy();
        }
        if (methodName.equals("embeddings") && parameterTypes.length == 0) {
            return new InstrumentedEmbeddingServiceAsync(((OpenAIClientAsync)this.delegate).embeddings(), this.embeddingInstrumenter).createProxy();
        }
        if (methodName.equals("sync") && parameterTypes.length == 0) {
            return new InstrumentedOpenAiClient(((OpenAIClientAsync)this.delegate).sync(), this.chatInstrumenter, this.embeddingInstrumenter, this.captureMessageContent).createProxy();
        }
        return super.invoke(proxy, method, args);
    }

    private Object createChatServiceAsyncProxy() {
        return Proxy.newProxyInstance(ChatServiceAsync.class.getClassLoader(), new Class[]{ChatServiceAsync.class}, (p, m, a) -> {
            if ("completions".equals(m.getName()) && m.getParameterCount() == 0) {
                return new InstrumentedChatCompletionServiceAsync(((OpenAIClientAsync)this.delegate).chat().completions(), this.chatInstrumenter, this.captureMessageContent).createProxy();
            }
            return m.invoke((Object)((OpenAIClientAsync)this.delegate).chat(), a);
        });
    }
}

