/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.client.OpenAIClient;
import com.openai.client.OpenAIClientAsync;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.embeddings.CreateEmbeddingResponse;
import com.openai.models.embeddings.EmbeddingCreateParams;
import dev.braintrust.instrumentation.openai.otel.InstrumentedOpenAiClient;
import dev.braintrust.instrumentation.openai.otel.InstrumentedOpenAiClientAsync;
import dev.braintrust.instrumentation.openai.otel.OpenAITelemetryBuilder;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;

public final class OpenAITelemetry {
    private final Instrumenter<ChatCompletionCreateParams, ChatCompletion> chatInstrumenter;
    private final Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> embeddingsInstrumenter;
    private final boolean captureMessageContent;

    public static OpenAITelemetry create(OpenTelemetry openTelemetry) {
        return OpenAITelemetry.builder(openTelemetry).build();
    }

    public static OpenAITelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new OpenAITelemetryBuilder(openTelemetry);
    }

    OpenAITelemetry(Instrumenter<ChatCompletionCreateParams, ChatCompletion> chatInstrumenter, Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse> embeddingsInstrumenter, boolean captureMessageContent) {
        this.chatInstrumenter = chatInstrumenter;
        this.embeddingsInstrumenter = embeddingsInstrumenter;
        this.captureMessageContent = captureMessageContent;
    }

    public OpenAIClient wrap(OpenAIClient client) {
        return (OpenAIClient)new InstrumentedOpenAiClient(client, this.chatInstrumenter, this.embeddingsInstrumenter, this.captureMessageContent).createProxy();
    }

    public OpenAIClientAsync wrap(OpenAIClientAsync client) {
        return (OpenAIClientAsync)new InstrumentedOpenAiClientAsync(client, this.chatInstrumenter, this.embeddingsInstrumenter, this.captureMessageContent).createProxy();
    }
}

