/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.embeddings.CreateEmbeddingResponse;
import com.openai.models.embeddings.EmbeddingCreateParams;
import dev.braintrust.instrumentation.openai.otel.ChatAttributesGetter;
import dev.braintrust.instrumentation.openai.otel.EmbeddingAttributesGetter;
import dev.braintrust.instrumentation.openai.otel.OpenAITelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;

public final class OpenAITelemetryBuilder {
    static final String INSTRUMENTATION_NAME = "io.opentelemetry.openai-java-1.1";
    private final OpenTelemetry openTelemetry;
    private boolean captureMessageContent;

    OpenAITelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public OpenAITelemetryBuilder setCaptureMessageContent(boolean captureMessageContent) {
        this.captureMessageContent = captureMessageContent;
        return this;
    }

    public OpenAITelemetry build() {
        SpanNameExtractor chatSpanNameExtractor = request -> "Chat Completion";
        SpanNameExtractor embeddingSpanNameExtractor = request -> "Embedding";
        Instrumenter chatInstrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)chatSpanNameExtractor).addAttributesExtractor(GenAiAttributesExtractor.create((GenAiAttributesGetter)ChatAttributesGetter.INSTANCE)).addOperationMetrics(GenAiClientMetrics.get()).buildInstrumenter();
        Instrumenter embeddingsInstrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)embeddingSpanNameExtractor).addAttributesExtractor(GenAiAttributesExtractor.create((GenAiAttributesGetter)EmbeddingAttributesGetter.INSTANCE)).addOperationMetrics(GenAiClientMetrics.get()).buildInstrumenter(SpanKindExtractor.alwaysClient());
        return new OpenAITelemetry((Instrumenter<ChatCompletionCreateParams, ChatCompletion>)chatInstrumenter, (Instrumenter<EmbeddingCreateParams, CreateEmbeddingResponse>)embeddingsInstrumenter, this.captureMessageContent);
    }
}

