/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionChunk;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.completions.CompletionUsage;
import dev.braintrust.instrumentation.openai.otel.BraintrustOAISpanAttributes;
import dev.braintrust.instrumentation.openai.otel.StreamedMessageBuffer;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class StreamListener {
    private final Context context;
    private final ChatCompletionCreateParams request;
    private final List<StreamedMessageBuffer> choiceBuffers;
    private final Instrumenter<ChatCompletionCreateParams, ChatCompletion> instrumenter;
    private final boolean captureMessageContent;
    private final boolean newSpan;
    private final AtomicBoolean hasEnded;
    private final AtomicBoolean firstChunkReceived;
    private final long startTimeNanos;
    @Nullable
    private CompletionUsage usage;
    @Nullable
    private String model;
    @Nullable
    private String responseId;

    StreamListener(Context context, ChatCompletionCreateParams request, Instrumenter<ChatCompletionCreateParams, ChatCompletion> instrumenter, boolean captureMessageContent, boolean newSpan, long startTimeNanos) {
        this.context = context;
        this.request = request;
        this.instrumenter = instrumenter;
        this.captureMessageContent = captureMessageContent;
        this.newSpan = newSpan;
        this.startTimeNanos = startTimeNanos;
        this.choiceBuffers = new ArrayList<StreamedMessageBuffer>();
        this.hasEnded = new AtomicBoolean();
        this.firstChunkReceived = new AtomicBoolean();
    }

    void onChunk(ChatCompletionChunk chunk) {
        if (this.firstChunkReceived.compareAndSet(false, true)) {
            long elapsedNanos = System.nanoTime() - this.startTimeNanos;
            double timeToFirstTokenSeconds = (double)elapsedNanos / 1.0E9;
            BraintrustOAISpanAttributes.setTimeToFirstToken(Span.fromContext((Context)this.context), timeToFirstTokenSeconds);
        }
        this.model = chunk.model();
        this.responseId = chunk.id();
        chunk.usage().ifPresent(u -> {
            this.usage = u;
        });
        for (ChatCompletionChunk.Choice choice : chunk.choices()) {
            while ((long)this.choiceBuffers.size() <= choice.index()) {
                this.choiceBuffers.add(null);
            }
            StreamedMessageBuffer buffer = this.choiceBuffers.get((int)choice.index());
            if (buffer == null) {
                buffer = new StreamedMessageBuffer(choice.index(), this.captureMessageContent);
                this.choiceBuffers.set((int)choice.index(), buffer);
            }
            buffer.append(choice.delta());
            if (!choice.finishReason().isPresent()) continue;
            buffer.finishReason = ((ChatCompletionChunk.Choice.FinishReason)choice.finishReason().get()).toString();
        }
    }

    void endSpan(@Nullable Throwable error) {
        if (!this.hasEnded.compareAndSet(false, true)) {
            return;
        }
        if (this.model == null || this.responseId == null) {
            if (this.newSpan) {
                this.instrumenter.end(this.context, (Object)this.request, null, error);
            }
            return;
        }
        ChatCompletion.Builder result = ChatCompletion.builder().created(0L).model(this.model).id(this.responseId).choices(this.choiceBuffers.stream().map(StreamedMessageBuffer::toChoice).collect(Collectors.toList()));
        if (this.usage != null) {
            result.usage(this.usage);
        }
        if (this.newSpan) {
            ChatCompletion completion = result.build();
            BraintrustOAISpanAttributes.setOutputMessagesFromCompletion(Span.fromContext((Context)this.context), completion);
            this.instrumenter.end(this.context, (Object)this.request, (Object)completion, error);
        }
    }
}

