/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.core.JsonField;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionChunk;
import com.openai.models.chat.completions.ChatCompletionMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

final class StreamedMessageBuffer {
    private final long index;
    private final boolean captureMessageContent;
    @Nullable
    String finishReason;
    @Nullable
    private StringBuilder message;
    @Nullable
    private Map<Long, ToolCallBuffer> toolCalls;

    StreamedMessageBuffer(long index, boolean captureMessageContent) {
        this.index = index;
        this.captureMessageContent = captureMessageContent;
    }

    ChatCompletion.Choice toChoice() {
        ChatCompletion.Choice.Builder choice = ChatCompletion.Choice.builder().index(this.index).logprobs(Optional.empty());
        if (this.finishReason != null) {
            choice.finishReason(ChatCompletion.Choice.FinishReason.of((String)this.finishReason));
        } else {
            choice.finishReason(JsonField.ofNullable(null));
        }
        if (this.message != null) {
            choice.message(ChatCompletionMessage.builder().content(this.message.toString()).refusal(Optional.empty()).build());
        } else {
            choice.message(JsonField.ofNullable(null));
        }
        return choice.build();
    }

    void append(ChatCompletionChunk.Choice.Delta delta) {
        if (this.captureMessageContent && delta.content().isPresent()) {
            if (this.message == null) {
                this.message = new StringBuilder();
            }
            this.message.append((String)delta.content().get());
        }
        if (delta.toolCalls().isPresent()) {
            if (this.toolCalls == null) {
                this.toolCalls = new HashMap<Long, ToolCallBuffer>();
            }
            for (ChatCompletionChunk.Choice.Delta.ToolCall toolCall : (List)delta.toolCalls().get()) {
                ToolCallBuffer buffer = this.toolCalls.computeIfAbsent(toolCall.index(), unused -> new ToolCallBuffer(toolCall.id().orElse("")));
                toolCall.type().ifPresent(type -> {
                    buffer.type = type.toString();
                });
                toolCall.function().ifPresent(function -> {
                    function.name().ifPresent(name -> {
                        buffer.function.name = name;
                    });
                    if (this.captureMessageContent) {
                        function.arguments().ifPresent(args -> {
                            if (buffer.function.arguments == null) {
                                buffer.function.arguments = new StringBuilder();
                            }
                            buffer.function.arguments.append((String)args);
                        });
                    }
                });
            }
        }
    }

    private static class ToolCallBuffer {
        final String id;
        final FunctionBuffer function = new FunctionBuffer();
        @Nullable
        String type;

        ToolCallBuffer(String id) {
            this.id = id;
        }
    }

    private static class FunctionBuffer {
        @Nullable
        String name;
        @Nullable
        StringBuilder arguments;

        private FunctionBuffer() {
        }
    }
}

