/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.core.http.AsyncStreamResponse;
import com.openai.models.chat.completions.ChatCompletionChunk;
import dev.braintrust.instrumentation.openai.otel.StreamListener;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

final class TracingAsyncStreamedResponse
implements AsyncStreamResponse<ChatCompletionChunk> {
    private final AsyncStreamResponse<ChatCompletionChunk> delegate;
    private final StreamListener listener;

    TracingAsyncStreamedResponse(AsyncStreamResponse<ChatCompletionChunk> delegate, StreamListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public void close() {
        this.listener.endSpan(null);
        this.delegate.close();
    }

    public AsyncStreamResponse<ChatCompletionChunk> subscribe(AsyncStreamResponse.Handler<? super ChatCompletionChunk> handler) {
        this.delegate.subscribe((AsyncStreamResponse.Handler)new TracingHandler(handler));
        return this;
    }

    public AsyncStreamResponse<ChatCompletionChunk> subscribe(AsyncStreamResponse.Handler<? super ChatCompletionChunk> handler, Executor executor) {
        this.delegate.subscribe((AsyncStreamResponse.Handler)new TracingHandler(handler), executor);
        return this;
    }

    public CompletableFuture<Void> onCompleteFuture() {
        return this.delegate.onCompleteFuture();
    }

    private class TracingHandler
    implements AsyncStreamResponse.Handler<ChatCompletionChunk> {
        private final AsyncStreamResponse.Handler<? super ChatCompletionChunk> delegate;

        private TracingHandler(AsyncStreamResponse.Handler<? super ChatCompletionChunk> delegate) {
            this.delegate = delegate;
        }

        public void onNext(ChatCompletionChunk chunk) {
            TracingAsyncStreamedResponse.this.listener.onChunk(chunk);
            this.delegate.onNext((Object)chunk);
        }

        public void onComplete(Optional<Throwable> error) {
            TracingAsyncStreamedResponse.this.listener.endSpan(error.orElse(null));
            this.delegate.onComplete(error);
        }
    }
}

