/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.instrumentation.openai.otel;

import com.openai.core.http.StreamResponse;
import com.openai.models.chat.completions.ChatCompletionChunk;
import dev.braintrust.instrumentation.openai.otel.StreamListener;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

final class TracingStreamedResponse
implements StreamResponse<ChatCompletionChunk> {
    private final StreamResponse<ChatCompletionChunk> delegate;
    private final StreamListener listener;

    TracingStreamedResponse(StreamResponse<ChatCompletionChunk> delegate, StreamListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public Stream<ChatCompletionChunk> stream() {
        return StreamSupport.stream(new TracingSpliterator(this.delegate.stream().spliterator()), false);
    }

    public void close() {
        this.listener.endSpan(null);
        this.delegate.close();
    }

    private class TracingSpliterator
    implements Spliterator<ChatCompletionChunk> {
        private final Spliterator<ChatCompletionChunk> delegateSpliterator;

        private TracingSpliterator(Spliterator<ChatCompletionChunk> delegateSpliterator) {
            this.delegateSpliterator = delegateSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super ChatCompletionChunk> action) {
            boolean chunkReceived = this.delegateSpliterator.tryAdvance((? super T chunk) -> {
                TracingStreamedResponse.this.listener.onChunk((ChatCompletionChunk)chunk);
                action.accept((ChatCompletionChunk)chunk);
            });
            if (!chunkReceived) {
                TracingStreamedResponse.this.listener.endSpan(null);
            }
            return chunkReceived;
        }

        @Override
        @Nullable
        public Spliterator<ChatCompletionChunk> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.delegateSpliterator.estimateSize();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.delegateSpliterator.getExactSizeIfKnown();
        }

        @Override
        public int characteristics() {
            return this.delegateSpliterator.characteristics();
        }

        @Override
        public Comparator<? super ChatCompletionChunk> getComparator() {
            return this.delegateSpliterator.getComparator();
        }
    }
}

