/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.prompt;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import dev.braintrust.api.BraintrustApiClient;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BraintrustPrompt {
    private final BraintrustApiClient.Prompt apiPrompt;
    private final Map<String, String> defaults;

    public BraintrustPrompt(BraintrustApiClient.Prompt apiPrompt) {
        this(apiPrompt, Map.of());
    }

    public BraintrustPrompt(BraintrustApiClient.Prompt apiPrompt, Map<String, String> defaults) {
        this.apiPrompt = apiPrompt;
        this.defaults = defaults;
    }

    public List<Map<String, Object>> renderMessages(Map<String, Object> parameters) {
        Map promptData = (Map)this.apiPrompt.promptData().prompt();
        List messages = (List)promptData.get("messages");
        if (messages == null) {
            throw new RuntimeException("No messages found in prompt data");
        }
        ArrayList<Map<String, Object>> renderedMessages = new ArrayList<Map<String, Object>>();
        for (Map message : messages) {
            HashMap<String, String> renderedMessage = new HashMap<String, String>(message);
            String content = (String)message.get("content");
            if (content != null) {
                String renderedContent = this.renderTemplate(content, parameters);
                renderedMessage.put("content", renderedContent);
            }
            renderedMessages.add(renderedMessage);
        }
        return renderedMessages;
    }

    public Map<String, Object> getOptions() {
        Map options = (Map)this.apiPrompt.promptData().options();
        if (options == null) {
            return Map.of();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : options.entrySet()) {
            if ("params".equals(entry.getKey())) continue;
            result.put((String)entry.getKey(), entry.getValue());
        }
        Map params = (Map)options.get("params");
        if (params != null) {
            result.putAll(params);
        }
        for (Map.Entry<String, String> defaultEntry : this.defaults.entrySet()) {
            if (result.containsKey(defaultEntry.getKey())) continue;
            result.put(defaultEntry.getKey(), defaultEntry.getValue());
        }
        return result;
    }

    private String renderTemplate(String template, Map<String, Object> parameters) {
        try {
            DefaultMustacheFactory factory = new DefaultMustacheFactory();
            Mustache mustache = factory.compile((Reader)new StringReader(template), "template");
            StringWriter writer = new StringWriter();
            mustache.execute((Writer)writer, parameters);
            writer.flush();
            return writer.toString();
        }
        catch (MustacheException e) {
            return template;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to render template", e);
        }
    }
}

