/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.prompt;

import dev.braintrust.api.BraintrustApiClient;
import dev.braintrust.config.BraintrustConfig;
import dev.braintrust.prompt.BraintrustPrompt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class BraintrustPromptLoader {
    private final BraintrustConfig config;
    private final BraintrustApiClient client;

    private BraintrustPromptLoader(BraintrustConfig config, BraintrustApiClient client) {
        this.config = config;
        this.client = client;
    }

    public static BraintrustPromptLoader of(BraintrustConfig config, BraintrustApiClient client) {
        return new BraintrustPromptLoader(config, client);
    }

    public BraintrustPrompt load(String promptSlug) {
        PromptLoadRequest request = PromptLoadRequest.builder().promptSlug(promptSlug).build();
        return this.load(request);
    }

    public BraintrustPrompt load(PromptLoadRequest promptLoadRequest) {
        String projectName = promptLoadRequest.projectName;
        if (null == projectName) {
            projectName = this.config.defaultProjectName().orElseThrow();
        }
        Optional<BraintrustApiClient.Prompt> promptOpt = this.client.getPrompt(projectName, promptLoadRequest.promptSlug, promptLoadRequest.version);
        BraintrustApiClient.Prompt prompt = promptOpt.orElseThrow(() -> new RuntimeException("Prompt not found: " + promptLoadRequest.promptSlug));
        return new BraintrustPrompt(prompt, promptLoadRequest.defaults);
    }

    private static <T> Map<T, T> keyValueListToMap(T ... keyValueList) {
        if (keyValueList.length % 2 != 0) {
            throw new IllegalArgumentException("keyValueList must contain an even number of elements (key-value pairs)");
        }
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (int i = 0; i < keyValueList.length; i += 2) {
            T key = keyValueList[i];
            T value = keyValueList[i + 1];
            map.put(key, value);
        }
        return Map.copyOf(map);
    }

    public static class PromptLoadRequest {
        @Nonnull
        private String promptSlug;
        @Nullable
        private String projectName;
        @Nullable
        private String version;
        @Nonnull
        private Map<String, String> defaults;

        @Generated
        private static Map<String, String> $default$defaults() {
            return Map.of();
        }

        @Generated
        PromptLoadRequest(@Nonnull String promptSlug, @Nullable String projectName, @Nullable String version, @Nonnull Map<String, String> defaults) {
            if (promptSlug == null) {
                throw new NullPointerException("promptSlug is marked non-null but is null");
            }
            if (defaults == null) {
                throw new NullPointerException("defaults is marked non-null but is null");
            }
            this.promptSlug = promptSlug;
            this.projectName = projectName;
            this.version = version;
            this.defaults = defaults;
        }

        @Generated
        public static PromptLoadRequestBuilder builder() {
            return new PromptLoadRequestBuilder();
        }

        public static class PromptLoadRequestBuilder {
            @Generated
            private String promptSlug;
            @Generated
            private String projectName;
            @Generated
            private String version;
            @Generated
            private boolean defaults$set;
            @Generated
            private Map<String, String> defaults$value;

            public PromptLoadRequestBuilder defaults(String ... keyValuePairDefaults) {
                this.defaults$value = BraintrustPromptLoader.keyValueListToMap(keyValuePairDefaults);
                this.defaults$set = true;
                return this;
            }

            @Generated
            PromptLoadRequestBuilder() {
            }

            @Generated
            public PromptLoadRequestBuilder promptSlug(@Nonnull String promptSlug) {
                if (promptSlug == null) {
                    throw new NullPointerException("promptSlug is marked non-null but is null");
                }
                this.promptSlug = promptSlug;
                return this;
            }

            @Generated
            public PromptLoadRequestBuilder projectName(@Nullable String projectName) {
                this.projectName = projectName;
                return this;
            }

            @Generated
            public PromptLoadRequestBuilder version(@Nullable String version) {
                this.version = version;
                return this;
            }

            @Generated
            public PromptLoadRequest build() {
                Map<String, String> defaults$value = this.defaults$value;
                if (!this.defaults$set) {
                    defaults$value = PromptLoadRequest.$default$defaults();
                }
                return new PromptLoadRequest(this.promptSlug, this.projectName, this.version, defaults$value);
            }

            @Generated
            public String toString() {
                return "BraintrustPromptLoader.PromptLoadRequest.PromptLoadRequestBuilder(promptSlug=" + this.promptSlug + ", projectName=" + this.projectName + ", version=" + this.version + ", defaults$value=" + String.valueOf(this.defaults$value) + ")";
            }
        }
    }
}

