/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.trace;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;

public class Base64Attachment {
    @JsonProperty(value="type")
    private final String type = "base64_attachment";
    @JsonProperty(value="content")
    private final String base64Data;

    private Base64Attachment(@Nonnull String base64Data) {
        if (Objects.requireNonNull(base64Data).isEmpty()) {
            throw new IllegalArgumentException("base64Data cannot be empty");
        }
        if (!base64Data.startsWith("data:") || !base64Data.contains(";base64,")) {
            throw new IllegalArgumentException("base64Data must be a data URL with format: data:<mime-type>;base64,<base64-string>");
        }
        this.base64Data = base64Data;
    }

    public static Base64Attachment of(String base64DataUri) {
        return new Base64Attachment(base64DataUri);
    }

    public static Base64Attachment ofFile(ContentType contentType, String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            byte[] fileBytes = Files.readAllBytes(path);
            String base64Encoded = Base64.getEncoder().encodeToString(fileBytes);
            String dataUrl = "data:" + contentType.getMimeType() + ";base64," + base64Encoded;
            return Base64Attachment.of(dataUrl);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file: " + filePath, e);
        }
    }

    public static JsonSerializer<Base64Attachment> createSerializer() {
        return new JsonSerializer<Base64Attachment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serialize(Base64Attachment value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeStartObject();
                try {
                    gen.writeStringField("type", value.type);
                    gen.writeStringField("content", value.base64Data);
                }
                finally {
                    gen.writeEndObject();
                }
            }
        };
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getBase64Data() {
        return this.base64Data;
    }

    public static class ContentType {
        public static ContentType IMAGE_PNG = new ContentType("image/png");
        public static ContentType IMAGE_JPEG = new ContentType("image/jpeg");
        public static ContentType IMAGE_GIF = new ContentType("image/gif");
        public static ContentType IMAGE_WEBP = new ContentType("image/webp");
        public static ContentType IMAGE_SVG = new ContentType("image/svg+xml");
        public static ContentType APPLICATION_PDF = new ContentType("application/pdf");
        public static ContentType TEXT_PLAIN = new ContentType("text/plain");
        public static ContentType APPLICATION_JSON = new ContentType("application/json");
        @Nonnull
        private final String mimeType;

        public static ContentType of(@Nonnull String mimeType) {
            return new ContentType(mimeType);
        }

        public int hashCode() {
            return this.mimeType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContentType) {
                return this.mimeType.equals(((ContentType)obj).mimeType);
            }
            return super.equals(obj);
        }

        private ContentType(@Nonnull String mimeType) {
            Objects.requireNonNull(mimeType);
            this.mimeType = mimeType.toLowerCase();
        }

        @Nonnull
        @Generated
        public String getMimeType() {
            return this.mimeType;
        }
    }
}

