/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.trace;

import dev.braintrust.BraintrustUtils;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraintrustContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustContext.class);
    private static final ContextKey<BraintrustContext> KEY = ContextKey.named((String)"braintrust-context");
    @Nullable
    private final String projectId;
    @Nullable
    private final String experimentId;

    private BraintrustContext(@Nullable String projectId, @Nullable String experimentId) {
        this.projectId = projectId;
        this.experimentId = experimentId;
    }

    public static Context ofExperiment(@Nonnull String experimentId, @Nonnull Span span) {
        Objects.requireNonNull(experimentId);
        Objects.requireNonNull(span);
        Context ctx = Context.current().with((ImplicitContextKeyed)span).with(KEY, (Object)new BraintrustContext(null, experimentId));
        return BraintrustContext.setParentInBaggage(ctx, "experiment_id", experimentId);
    }

    public static Context setParentInBaggage(@Nonnull Context ctx, @Nonnull String parentType, @Nonnull String parentId) {
        try {
            String parentValue = new BraintrustUtils.Parent(parentType, parentId).toParentValue();
            Baggage existingBaggage = Baggage.fromContext((Context)ctx);
            BaggageBuilder builder = existingBaggage.toBuilder();
            builder.put("braintrust.parent", parentValue);
            return ctx.with((ImplicitContextKeyed)builder.build());
        }
        catch (Exception e) {
            log.warn("Failed to set parent in baggage: {}", (Object)e.getMessage(), (Object)e);
            return ctx;
        }
    }

    static Optional<String> getParentFromBaggage(@Nonnull Context ctx) {
        try {
            Baggage baggage = Baggage.fromContext((Context)ctx);
            String parentValue = baggage.getEntryValue("braintrust.parent");
            return Optional.ofNullable(parentValue).filter(s -> !s.isEmpty());
        }
        catch (Exception e) {
            log.warn("Failed to get parent from baggage: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    @Nullable
    public static BraintrustContext fromContext(Context context) {
        return (BraintrustContext)context.get(KEY);
    }

    public Optional<String> projectId() {
        return Optional.ofNullable(this.projectId);
    }

    public Optional<String> experimentId() {
        return Optional.ofNullable(this.experimentId);
    }
}

