/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.trace;

import dev.braintrust.config.BraintrustConfig;
import dev.braintrust.trace.BraintrustSpanProcessor;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BraintrustLogExporter
implements LogRecordExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustLogExporter.class);
    private final BraintrustConfig config;
    private final String logsEndpoint;
    private final Map<String, OtlpHttpLogRecordExporter> exporterCache = new ConcurrentHashMap<String, OtlpHttpLogRecordExporter>();

    public BraintrustLogExporter(BraintrustConfig config) {
        this.config = config;
        this.logsEndpoint = config.apiUrl() + config.logsPath();
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (logs.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        Map<String, List<LogRecordData>> logsByParent = logs.stream().collect(Collectors.groupingBy(this::getParentFromLog));
        List<CompletableResultCode> results = logsByParent.entrySet().stream().map(entry -> this.exportWithParent((String)entry.getKey(), (List)entry.getValue())).toList();
        CompletableResultCode combined = CompletableResultCode.ofAll(results);
        return combined;
    }

    private String getParentFromLog(LogRecordData log) {
        String parent = (String)log.getAttributes().get(BraintrustSpanProcessor.PARENT);
        if (parent != null) {
            return parent;
        }
        return this.config.getBraintrustParentValue().orElse("");
    }

    private CompletableResultCode exportWithParent(String parent, List<LogRecordData> logs) {
        try {
            if (this.exporterCache.size() >= 1024) {
                log.info("Clearing exporter cache. This should not happen");
                this.exporterCache.clear();
            }
            OtlpHttpLogRecordExporter exporter = this.exporterCache.computeIfAbsent(parent, p -> {
                OtlpHttpLogRecordExporterBuilder exporterBuilder = OtlpHttpLogRecordExporter.builder().setEndpoint(this.logsEndpoint).addHeader("Authorization", "Bearer " + this.config.apiKey()).setTimeout(this.config.requestTimeout());
                if (!p.isEmpty()) {
                    exporterBuilder.addHeader("x-bt-parent", p);
                    log.debug("Created log exporter with x-bt-parent: {}", p);
                }
                return exporterBuilder.build();
            });
            CompletableResultCode result = exporter.export(logs);
            return result.whenComplete(() -> {
                if (result.isSuccess()) {
                    log.debug("Successfully exported {} logs with x-bt-parent: {}", (Object)logs.size(), (Object)parent);
                } else {
                    log.warn("Failed to export {} spans to endpoint {}", new Object[]{logs.size(), this.logsEndpoint, result.getFailureThrowable()});
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to export logs", (Throwable)e);
            return CompletableResultCode.ofFailure();
        }
    }

    public CompletableResultCode flush() {
        List<CompletableResultCode> results = this.exporterCache.values().stream().map(OtlpHttpLogRecordExporter::flush).toList();
        return CompletableResultCode.ofAll(results);
    }

    public CompletableResultCode shutdown() {
        List<CompletableResultCode> results = this.exporterCache.values().stream().map(OtlpHttpLogRecordExporter::shutdown).toList();
        this.exporterCache.clear();
        return CompletableResultCode.ofAll(results);
    }
}

