/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.trace;

import dev.braintrust.config.BraintrustConfig;
import dev.braintrust.trace.BraintrustSpanProcessor;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BraintrustSpanExporter
implements SpanExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustSpanExporter.class);
    private final BraintrustConfig config;
    private final String tracesEndpoint;
    private final Map<String, OtlpHttpSpanExporter> exporterCache = new ConcurrentHashMap<String, OtlpHttpSpanExporter>();

    public BraintrustSpanExporter(BraintrustConfig config) {
        this.config = config;
        this.tracesEndpoint = config.apiUrl() + config.tracesPath();
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (spans.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        Map<String, List<SpanData>> spansByParent = spans.stream().collect(Collectors.groupingBy(this::getParentFromSpan));
        List<CompletableResultCode> results = spansByParent.entrySet().stream().map(entry -> this.exportWithParent((String)entry.getKey(), (List)entry.getValue())).toList();
        CompletableResultCode combined = CompletableResultCode.ofAll(results);
        log.debug("span export results: {}", (Object)combined.isSuccess());
        return combined;
    }

    private String getParentFromSpan(SpanData span) {
        String parent = (String)span.getAttributes().get(BraintrustSpanProcessor.PARENT);
        if (parent != null) {
            return parent;
        }
        return this.config.getBraintrustParentValue().orElse("");
    }

    private CompletableResultCode exportWithParent(String parent, List<SpanData> spans) {
        try {
            if (this.exporterCache.size() >= 1024) {
                log.info("Clearing exporter cache. This should not happen");
                this.exporterCache.clear();
            }
            OtlpHttpSpanExporter exporter = this.exporterCache.computeIfAbsent(parent, p -> {
                OtlpHttpSpanExporterBuilder exporterBuilder = OtlpHttpSpanExporter.builder().setEndpoint(this.tracesEndpoint).setSslContext(this.config.sslContext(), this.config.x509TrustManager()).addHeader("Authorization", "Bearer " + this.config.apiKey()).setTimeout(this.config.requestTimeout());
                if (!p.isEmpty()) {
                    exporterBuilder.addHeader("x-bt-parent", p);
                    log.debug("Created exporter with x-bt-parent: {}", p);
                }
                return exporterBuilder.build();
            });
            if (this.config.exportSpansInMemoryForUnitTest()) {
                return CompletableResultCode.ofSuccess();
            }
            CompletableResultCode result = exporter.export(spans);
            return result.whenComplete(() -> {
                if (result.isSuccess()) {
                    log.debug("Successfully exported {} spans with x-bt-parent: {}", (Object)spans.size(), (Object)parent);
                } else {
                    log.warn("Failed to export {} spans to endpoint {}", new Object[]{spans.size(), this.tracesEndpoint, result.getFailureThrowable()});
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to export spans", (Throwable)e);
            return CompletableResultCode.ofFailure();
        }
    }

    public CompletableResultCode flush() {
        List<CompletableResultCode> results = this.exporterCache.values().stream().map(OtlpHttpSpanExporter::flush).toList();
        return CompletableResultCode.ofAll(results);
    }

    public CompletableResultCode shutdown() {
        List<CompletableResultCode> results = this.exporterCache.values().stream().map(OtlpHttpSpanExporter::shutdown).toList();
        this.exporterCache.clear();
        return CompletableResultCode.ofAll(results);
    }
}

