/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.trace;

import dev.braintrust.config.BraintrustConfig;
import dev.braintrust.trace.BraintrustContext;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BraintrustSpanProcessor
implements SpanProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustSpanProcessor.class);
    public static final AttributeKey<String> PARENT = AttributeKey.stringKey((String)"braintrust.parent");
    private final BraintrustConfig config;
    private final SpanProcessor delegate;
    private final ConcurrentMap<String, ParentContext> parentContexts = new ConcurrentHashMap<String, ParentContext>();

    public BraintrustSpanProcessor(BraintrustConfig config, SpanProcessor delegate) {
        this.config = config;
        this.delegate = delegate;
    }

    public void onStart(@NotNull Context parentContext, ReadWriteSpan span) {
        log.debug("OnStart: span={}, parent={}", (Object)span.getName(), (Object)parentContext);
        if (span.getAttribute(PARENT) == null) {
            BraintrustContext btContext = BraintrustContext.fromContext(parentContext);
            if (btContext == null) {
                Optional<String> parentFromBaggage = BraintrustContext.getParentFromBaggage(parentContext);
                if (parentFromBaggage.isPresent()) {
                    span.setAttribute(PARENT, (Object)parentFromBaggage.get());
                    log.debug("OnStart: set parent {} from baggage for span {}", (Object)parentFromBaggage.get(), (Object)span.getName());
                } else {
                    this.config.getBraintrustParentValue().ifPresent(parentValue -> {
                        span.setAttribute(PARENT, parentValue);
                        log.debug("OnStart: set parent {} for span {}", parentValue, (Object)span.getName());
                    });
                }
            } else {
                btContext.projectId().ifPresent(id -> {
                    span.setAttribute(PARENT, (Object)("project_id:" + id));
                    log.debug("OnStart: set parent project {} from context", id);
                });
                btContext.experimentId().ifPresent(id -> {
                    span.setAttribute(PARENT, (Object)("experiment_id:" + id));
                    log.debug("OnStart: set parent experiment {} from context", id);
                });
            }
        }
        this.delegate.onStart(parentContext, span);
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
        if (this.config.debug()) {
            this.logSpanDetails(span);
        }
        this.delegate.onEnd(span);
    }

    public boolean isEndRequired() {
        return this.delegate.isEndRequired();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public CompletableResultCode forceFlush() {
        return this.delegate.forceFlush();
    }

    public void setParentContext(String traceId, ParentContext context) {
        this.parentContexts.put(traceId, context);
    }

    public Optional<ParentContext> getParentContext(String traceId) {
        return Optional.ofNullable((ParentContext)this.parentContexts.get(traceId));
    }

    private void logSpanDetails(ReadableSpan span) {
        SpanData spanData = span.toSpanData();
        log.debug("Span completed: name={}, traceId={}, spanId={}, duration={}ms, attributes={}, events={}", new Object[]{spanData.getName(), spanData.getTraceId(), spanData.getSpanId(), (spanData.getEndEpochNanos() - spanData.getStartEpochNanos()) / 1000000L, spanData.getAttributes(), spanData.getEvents()});
    }

    public record ParentContext(@Nullable String projectId, @Nullable String experimentId, ParentType type) {
        public static ParentContext project(String projectId) {
            return new ParentContext(projectId, null, ParentType.PROJECT);
        }

        public static ParentContext experiment(String experimentId) {
            return new ParentContext(null, experimentId, ParentType.EXPERIMENT);
        }

        public static enum ParentType {
            PROJECT,
            EXPERIMENT;

        }
    }
}

