/*
 * Decompiled with CFR 0.152.
 */
package dev.braintrust.trace;

import dev.braintrust.config.BraintrustConfig;
import dev.braintrust.trace.BraintrustLogExporter;
import dev.braintrust.trace.BraintrustSpanExporter;
import dev.braintrust.trace.BraintrustSpanProcessor;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.InputStream;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraintrustTracing {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BraintrustTracing.class);
    public static final String PARENT_KEY = "braintrust.parent";
    static final String OTEL_SERVICE_NAME = "braintrust-app";
    static final String INSTRUMENTATION_NAME = "braintrust-java";
    static final String INSTRUMENTATION_VERSION = BraintrustTracing.loadVersionFromProperties();

    public static OpenTelemetry quickstart() {
        return BraintrustTracing.of(BraintrustConfig.fromEnvironment(), true);
    }

    public static OpenTelemetry of(@Nonnull BraintrustConfig config, boolean registerGlobal) {
        SdkTracerProviderBuilder tracerBuilder = SdkTracerProvider.builder();
        SdkLoggerProviderBuilder loggerBuilder = SdkLoggerProvider.builder();
        SdkMeterProviderBuilder meterBuilder = SdkMeterProvider.builder();
        ContextPropagators contextPropagator = ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()}));
        BraintrustTracing.enable(config, tracerBuilder, loggerBuilder, meterBuilder);
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerBuilder.build()).setLoggerProvider(loggerBuilder.build()).setMeterProvider(meterBuilder.build()).setPropagators(contextPropagator).build();
        if (registerGlobal) {
            GlobalOpenTelemetry.set((OpenTelemetry)openTelemetry);
            log.debug("Registered OpenTelemetry globally");
        }
        return openTelemetry;
    }

    public static void enable(@Nonnull BraintrustConfig config, @Nonnull SdkTracerProviderBuilder tracerProviderBuilder, @Nonnull SdkLoggerProviderBuilder loggerProviderBuilder, @Nonnull SdkMeterProviderBuilder meterProviderBuilder) {
        Duration exportInterval = Duration.ofSeconds(5L);
        int maxQueueSize = 2048;
        int maxExportBatchSize = 512;
        log.info(BraintrustTracing.sdkInfoLogMessage());
        ResourceBuilder resourceBuilder = Resource.getDefault().toBuilder().put(ResourceAttributes.SERVICE_NAME, (Object)OTEL_SERVICE_NAME).put(ResourceAttributes.SERVICE_VERSION, (Object)INSTRUMENTATION_VERSION);
        Resource resource = resourceBuilder.build();
        BraintrustSpanProcessor spanProcessor = new BraintrustSpanProcessor(config, (SpanProcessor)BatchSpanProcessor.builder((SpanExporter)new BraintrustSpanExporter(config)).setScheduleDelay(exportInterval.toMillis(), TimeUnit.MILLISECONDS).setMaxQueueSize(2048).setMaxExportBatchSize(512).build());
        tracerProviderBuilder.addResource(resource).addSpanProcessor((SpanProcessor)spanProcessor);
        BatchLogRecordProcessor logProcessor = BatchLogRecordProcessor.builder((LogRecordExporter)new BraintrustLogExporter(config)).setScheduleDelay(exportInterval.toMillis(), TimeUnit.MILLISECONDS).setMaxQueueSize(2048).setMaxExportBatchSize(512).build();
        loggerProviderBuilder.addLogRecordProcessor((LogRecordProcessor)logProcessor);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.debug("Shutting down. Force-Flushing all otel data.");
            CompletableResultCode result = CompletableResultCode.ofAll(Stream.of(spanProcessor.shutdown(), logProcessor.shutdown()).map(operation -> operation.join(10L, TimeUnit.SECONDS)).toList());
            log.debug("otel shutdown complete. Flush done: %s, Flush successful: %s".formatted(result.isDone(), result.isSuccess()));
        }));
    }

    public static Tracer getTracer() {
        return BraintrustTracing.getTracer(GlobalOpenTelemetry.get());
    }

    public static Tracer getTracer(OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer(INSTRUMENTATION_NAME, INSTRUMENTATION_VERSION);
    }

    private static String sdkInfoLogMessage() {
        return "Initializing Braintrust OpenTelemetry with service=%s, instrumentation-name=%s, instrumentation-version=%s, jvm-version=%s, jvm-vendor=%s, jvm-name=%s".formatted(OTEL_SERVICE_NAME, INSTRUMENTATION_NAME, INSTRUMENTATION_VERSION, System.getProperty("java.runtime.version"), System.getProperty("java.vendor"), System.getProperty("java.vm.name"));
    }

    static String loadVersionFromProperties() {
        String string;
        block8: {
            InputStream is = BraintrustTracing.class.getResourceAsStream("/braintrust.properties");
            try {
                Properties props = new Properties();
                props.load(is);
                string = props.getProperty("sdk.version");
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("unable to determine sdk version", e);
                }
            }
            is.close();
        }
        return string;
    }

    private BraintrustTracing() {
    }
}

