/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.java.internal.properties;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.java.JavaManagerException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={JavaPropertiesSingleton.class}, immediate=true)
public class JavaPropertiesSingleton {
    private static JavaPropertiesSingleton singletonInstance;
    private IConfigurationPropertyStoreService cps;

    private static void setInstance(JavaPropertiesSingleton instance) {
        singletonInstance = instance;
    }

    @Activate
    public void activate() {
        JavaPropertiesSingleton.setInstance(this);
    }

    @Deactivate
    public void deacivate() {
        JavaPropertiesSingleton.setInstance(null);
    }

    public static IConfigurationPropertyStoreService cps() throws JavaManagerException {
        if (singletonInstance != null) {
            return JavaPropertiesSingleton.singletonInstance.cps;
        }
        throw new JavaManagerException("Attempt to access manager CPS before it has been initialised");
    }

    public static void setCps(IConfigurationPropertyStoreService cps) throws JavaManagerException {
        if (singletonInstance != null) {
            JavaPropertiesSingleton.singletonInstance.cps = cps;
            return;
        }
        throw new JavaManagerException("Attempt to set manager CPS before instance created");
    }
}

