/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.posthog;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FeatureFlagState {
    public static final FeatureFlagState ENABLED = new FeatureFlagState(true, null, null);
    public static final FeatureFlagState DISABLED = new FeatureFlagState(false, null, null);
    public static final FeatureFlagState REMOTE_EVAL_NOT_ALLOWED = new FeatureFlagState(false, null, "remote evaluation is not allowed");
    private final boolean enabled;
    private final String variant;
    private final String inconclusiveReason;

    FeatureFlagState(boolean enabled) {
        this(enabled, null, null);
    }

    FeatureFlagState(boolean enabled, @Nullable String variant, @Nullable String inconclusiveReason) {
        this.enabled = enabled;
        this.variant = variant;
        this.inconclusiveReason = inconclusiveReason;
    }

    FeatureFlagState(@Nullable JsonObject featureFlags, @NotNull String key) {
        JsonElement jsonElement;
        this.inconclusiveReason = null;
        if (featureFlags == null || !featureFlags.has(key) || !((jsonElement = featureFlags.get(key)) instanceof JsonPrimitive)) {
            this.enabled = false;
            this.variant = null;
            return;
        }
        JsonPrimitive value = (JsonPrimitive)jsonElement;
        this.enabled = value.isString() || value.getAsBoolean();
        this.variant = value.isString() ? value.getAsString() : null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public String getVariant() {
        return this.variant;
    }

    public boolean isInconclusive() {
        return this.inconclusiveReason != null;
    }

    public String toString() {
        if (this.inconclusiveReason != null) {
            return String.format("inconclusive(%s)", this.inconclusiveReason);
        }
        if (this.variant != null) {
            return this.variant;
        }
        return String.valueOf(this.enabled);
    }
}

