/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPIConfig;
import java.io.File;
import java.util.List;
import java.util.function.Function;

public class InternalConfig {
    private final boolean verboseOutput;
    private final boolean silentLogs;
    private final boolean useLatestNMSVersion;
    private final String message_missingExecutorImplementation;
    private final File dispatcherFile;
    private final List<String> skipSenderProxy;
    private final Class<?> nbtContainerClass;
    private final Function<Object, ?> nbtContainerConstructor;

    public InternalConfig(CommandAPIConfig<?> config) {
        this.verboseOutput = config.verboseOutput;
        this.silentLogs = config.silentLogs;
        this.useLatestNMSVersion = config.useLatestNMSVersion;
        this.message_missingExecutorImplementation = config.missingExecutorImplementationMessage;
        this.dispatcherFile = config.dispatcherFile;
        this.skipSenderProxy = config.skipSenderProxy;
        this.nbtContainerClass = config.nbtContainerClass;
        this.nbtContainerConstructor = config.nbtContainerConstructor;
    }

    public boolean hasVerboseOutput() {
        return this.verboseOutput;
    }

    public boolean hasSilentLogs() {
        return this.silentLogs;
    }

    public boolean shouldUseLatestNMSVersion() {
        return this.useLatestNMSVersion;
    }

    public String getMissingImplementationMessage() {
        return this.message_missingExecutorImplementation;
    }

    public File getDispatcherFile() {
        return this.dispatcherFile;
    }

    public boolean shouldSkipSenderProxy(String commandName) {
        return this.skipSenderProxy.contains(commandName);
    }

    public Class<?> getNBTContainerClass() {
        return this.nbtContainerClass;
    }

    public Function<Object, ?> getNBTContainerConstructor() {
        return this.nbtContainerConstructor;
    }
}

