/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver;

import dev.katsute.simplehttpserver.FileRecord;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Record {
    private final Map<String, Header> headers;
    private final String name;
    private final String value;

    Record(Map.Entry<String, Map<String, ?>> entry) {
        this.name = Objects.requireNonNull(entry.getKey());
        this.value = Objects.requireNonNull(Objects.requireNonNull(entry.getValue()).get("value")).toString();
        HashMap<String, Header> headers = new HashMap<String, Header>();
        for (Map.Entry e : Objects.requireNonNull((Map)entry.getValue().get("headers")).entrySet()) {
            headers.put((String)e.getKey(), new Header(Objects.requireNonNull(((Map)e.getValue()).get("header-name")).toString(), Objects.requireNonNull(((Map)e.getValue()).get("header-value")).toString(), (Map)Objects.requireNonNull(((Map)e.getValue()).get("parameters"))));
        }
        this.headers = headers;
    }

    public final String getName() {
        return this.name;
    }

    public final String getValue() {
        return this.value;
    }

    public final Header getHeader(String key) {
        return this.headers.get(key);
    }

    public final Map<String, Header> getHeaders() {
        return new HashMap<String, Header>(this.headers);
    }

    public final boolean isFile() {
        return this instanceof FileRecord;
    }

    public final FileRecord asFile() {
        return (FileRecord)this;
    }

    public String toString() {
        return "Record{headers=" + this.headers + ", name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static class Header {
        private final String name;
        private final String value;
        private final Map<String, String> params;

        Header(String name, String value, Map<String, String> params) {
            this.name = name;
            this.value = value;
            this.params = new HashMap<String, String>(params);
        }

        public final String getName() {
            return this.name;
        }

        public final String getValue() {
            return this.value;
        }

        public final String getParameter(String key) {
            return this.params.get(Objects.requireNonNull(key));
        }

        public final Map<String, String> getParameters() {
            return new HashMap<String, String>(this.params);
        }
    }
}

