/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.throttler;

import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.handler.throttler.ConnectionThrottler;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerExchangeThrottler
extends ConnectionThrottler {
    private final Map<InetAddress, AtomicInteger> connections = new ConcurrentHashMap<InetAddress, AtomicInteger>();
    private final AtomicInteger connCount = new AtomicInteger(0);
    private final AtomicInteger maxConn = new AtomicInteger(-1);

    public ServerExchangeThrottler() {
    }

    public ServerExchangeThrottler(int maxConnections) {
        this.maxConn.set(maxConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean addConnection(SimpleHttpExchange exchange) {
        InetAddress address = exchange.getRemoteAddress().getAddress();
        int clientMaxConn = this.getMaxConnections(exchange);
        this.connections.putIfAbsent(address, new AtomicInteger(0));
        AtomicInteger conn = this.connections.get(address);
        boolean exempt = this.canIgnoreConnectionLimit(exchange);
        if (clientMaxConn < 0) {
            if (!exempt) {
                int maxServerConn = this.maxConn.get();
                ServerExchangeThrottler serverExchangeThrottler = this;
                synchronized (serverExchangeThrottler) {
                    if (maxServerConn < 0 || this.connCount.get() < maxServerConn) {
                        conn.incrementAndGet();
                        this.connCount.incrementAndGet();
                        return true;
                    }
                    return false;
                }
            }
            conn.incrementAndGet();
            return true;
        }
        if (!exempt) {
            int maxServerConn = this.maxConn.get();
            ServerExchangeThrottler serverExchangeThrottler = this;
            synchronized (serverExchangeThrottler) {
                if (conn.get() < clientMaxConn && (maxServerConn < 0 || this.connCount.get() < maxServerConn)) {
                    conn.incrementAndGet();
                    this.connCount.incrementAndGet();
                    return true;
                }
                return false;
            }
        }
        AtomicBoolean added = new AtomicBoolean(false);
        conn.updateAndGet(operand -> {
            if (operand < clientMaxConn) {
                added.set(true);
            }
            return operand < clientMaxConn ? operand + 1 : operand;
        });
        return added.get();
    }

    @Override
    final void deleteConnection(SimpleHttpExchange exchange) {
        InetAddress address = exchange.getRemoteAddress().getAddress();
        if (this.connections.containsKey(address)) {
            this.connections.get(address).decrementAndGet();
            if (!this.canIgnoreConnectionLimit(exchange)) {
                this.connCount.decrementAndGet();
            }
        }
    }

    @Override
    public int getMaxConnections(SimpleHttpExchange exchange) {
        return -1;
    }

    public boolean canIgnoreConnectionLimit(SimpleHttpExchange exchange) {
        return false;
    }

    public final synchronized void setMaxServerConnections(int connections) {
        this.maxConn.set(connections);
    }

    public final synchronized int getMaxServerConnections() {
        return this.maxConn.get();
    }

    public String toString() {
        return "ServerExchangeThrottler{connections=" + this.connections + ", connCount=" + this.connCount + ", maxConn=" + this.maxConn + '}';
    }
}

