/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.bytecodebuilder;

import dev.lukebemish.bytecodebuilder.ClassSignature;
import dev.lukebemish.bytecodebuilder.ImplClassContext;
import dev.lukebemish.bytecodebuilder.ImplCodeContext;
import dev.lukebemish.bytecodebuilder.ImplFieldContext;
import dev.lukebemish.bytecodebuilder.ImplMethodContext;
import dev.lukebemish.bytecodebuilder.MethodSignature;
import dev.lukebemish.bytecodebuilder.Signature;
import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.FieldBuilder;
import java.lang.classfile.Label;
import java.lang.classfile.MethodBuilder;
import java.lang.classfile.Opcode;
import java.lang.classfile.TypeKind;
import java.lang.classfile.attribute.ConstantValueAttribute;
import java.lang.classfile.attribute.ExceptionsAttribute;
import java.lang.classfile.attribute.SignatureAttribute;
import java.lang.classfile.instruction.OperatorInstruction;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public class BackendClassFile {
    public static ClassContextClassFile createClass(Consumer<? super ClassContextClassFile> consumer) {
        ClassContextClassFile context = new ClassContextClassFile();
        consumer.accept(context);
        return context;
    }

    public static ClassContextClassFile createClass() {
        return new ClassContextClassFile();
    }

    public static MethodContextClassFile createMethod(Consumer<? super MethodContextClassFile> consumer) {
        MethodContextClassFile context = new MethodContextClassFile();
        consumer.accept(context);
        return context;
    }

    public static MethodContextClassFile createMethod() {
        return new MethodContextClassFile();
    }

    public static FieldContextClassFile createField(Consumer<? super FieldContextClassFile> consumer) {
        FieldContextClassFile context = new FieldContextClassFile();
        consumer.accept(context);
        return context;
    }

    public static FieldContextClassFile createField() {
        return new FieldContextClassFile();
    }

    public static CodeContextClassFile createCode(Consumer<? super CodeContextClassFile> consumer) {
        CodeContextClassFile context = new CodeContextClassFile();
        consumer.accept(context);
        return context;
    }

    public static CodeContextClassFile createCode() {
        return new CodeContextClassFile();
    }

    public static final class ClassContextClassFile
    extends ImplClassContext<ClassContextClassFile, FieldContextClassFile, MethodContextClassFile> {
        private final List<Consumer<ClassBuilder>> classVisitors = new ArrayList<Consumer<ClassBuilder>>();

        private ClassContextClassFile() {
        }

        public ClassContextClassFile constructor(int access, MethodTypeDesc descriptor, @Nullable Collection<ClassDesc> exceptions, Consumer<? super MethodContextClassFile> remainder) {
            return this.method("<init>", access, descriptor, (MethodSignature)null, (Collection)exceptions, (Consumer)remainder);
        }

        public ClassContextClassFile method(String name, int access, MethodTypeDesc descriptor, @Nullable MethodSignature signature, @Nullable Collection<ClassDesc> exceptions, Consumer<? super MethodContextClassFile> remainder) {
            MethodContextClassFile methodContext = BackendClassFile.createMethod(remainder);
            this.classVisitors.add(b -> b.withMethod(name, descriptor, access, m -> {
                if (signature != null) {
                    m.with((ClassFileElement)SignatureAttribute.of((java.lang.classfile.Signature)java.lang.classfile.Signature.parseFrom((String)signature.signature())));
                }
                if (exceptions != null) {
                    m.with((ClassFileElement)ExceptionsAttribute.ofSymbols(exceptions.stream().toList()));
                }
                methodContext.apply((MethodBuilder)m);
            }));
            return this;
        }

        public ClassContextClassFile field(String name, int access, ClassDesc descriptor, @Nullable Signature signature, @Nullable ConstantDesc constant, Consumer<? super FieldContextClassFile> remainder) {
            FieldContextClassFile fieldContext = BackendClassFile.createField(remainder);
            this.classVisitors.add(b -> b.withField(name, descriptor, f -> {
                f.withFlags(access);
                if (signature != null) {
                    f.with((ClassFileElement)SignatureAttribute.of((java.lang.classfile.Signature)java.lang.classfile.Signature.parseFrom((String)signature.signature())));
                }
                if (constant != null) {
                    f.with((ClassFileElement)ConstantValueAttribute.of((ConstantDesc)constant));
                }
                fieldContext.apply((FieldBuilder)f);
            }));
            return this;
        }

        @Override
        public byte[] build(int version, int access, ClassDesc name, ClassDesc superName, @Nullable Collection<ClassDesc> interfaces, @Nullable ClassSignature signature) {
            ClassFile classFile = ClassFile.of();
            return classFile.build(name, cl -> {
                cl.withVersion(version, 0);
                cl.withSuperclass(superName);
                if (interfaces != null) {
                    cl.withInterfaceSymbols(interfaces.stream().toList());
                }
                if (signature != null) {
                    cl.with((ClassFileElement)SignatureAttribute.of((java.lang.classfile.Signature)java.lang.classfile.Signature.parseFrom((String)signature.signature())));
                }
                this.apply((ClassBuilder)cl);
            });
        }

        public ClassContextClassFile builder(Consumer<ClassBuilder> visitor) {
            this.classVisitors.add(visitor);
            return this;
        }

        public void apply(ClassBuilder classBuilder) {
            for (Consumer<ClassBuilder> visitor : this.classVisitors) {
                visitor.accept(classBuilder);
            }
        }
    }

    public static final class MethodContextClassFile
    extends ImplMethodContext<MethodContextClassFile, CodeContextClassFile> {
        private final List<Consumer<MethodBuilder>> methodVisitors = new ArrayList<Consumer<MethodBuilder>>();

        private MethodContextClassFile() {
        }

        public MethodContextClassFile builder(Consumer<MethodBuilder> visitor) {
            this.methodVisitors.add(visitor);
            return this;
        }

        public void apply(MethodBuilder methodBuilder) {
            for (Consumer<MethodBuilder> visitor : this.methodVisitors) {
                visitor.accept(methodBuilder);
            }
        }

        public MethodContextClassFile code(Consumer<? super CodeContextClassFile> consumer) {
            CodeContextClassFile codeContext = BackendClassFile.createCode(consumer);
            this.methodVisitors.add(b -> b.withCode(codeContext::apply));
            return this;
        }
    }

    public static final class FieldContextClassFile
    extends ImplFieldContext<FieldContextClassFile> {
        private final List<Consumer<FieldBuilder>> fieldVisitors = new ArrayList<Consumer<FieldBuilder>>();

        private FieldContextClassFile() {
        }

        public FieldContextClassFile builder(Consumer<FieldBuilder> visitor) {
            this.fieldVisitors.add(visitor);
            return this;
        }

        public void apply(FieldBuilder fieldBuilder) {
            for (Consumer<FieldBuilder> visitor : this.fieldVisitors) {
                visitor.accept(fieldBuilder);
            }
        }
    }

    public static final class CodeContextClassFile
    extends ImplCodeContext<CodeContextClassFile> {
        private final List<Consumer<CodeBuilder>> codeVisitors = new ArrayList<Consumer<CodeBuilder>>();

        private CodeContextClassFile() {
        }

        public CodeContextClassFile builder(Consumer<CodeBuilder> visitor) {
            this.codeVisitors.add(visitor);
            return this;
        }

        public void apply(CodeBuilder codeBuilder) {
            for (Consumer<CodeBuilder> visitor : this.codeVisitors) {
                visitor.accept(codeBuilder);
            }
        }

        public CodeContextClassFile instruction(Opcode opcode) {
            this.codeVisitors.add(b -> b.accept((ClassFileElement)OperatorInstruction.of((Opcode)opcode)));
            return this;
        }

        public CodeContextClassFile constant(ConstantDesc constant) {
            this.codeVisitors.add(b -> b.loadConstant(constant));
            return this;
        }

        public CodeContextClassFile load(ClassDesc descriptor, int index) {
            this.codeVisitors.add(b -> b.loadLocal(TypeKind.from((TypeDescriptor.OfField)descriptor), index));
            return this;
        }

        public CodeContextClassFile store(ClassDesc descriptor, int index) {
            this.codeVisitors.add(b -> b.storeLocal(TypeKind.from((TypeDescriptor.OfField)descriptor), index));
            return this;
        }

        public CodeContextClassFile newArray(ClassDesc descriptor) {
            this.codeVisitors.add(b -> {
                if (descriptor.isPrimitive()) {
                    b.newarray(TypeKind.from((TypeDescriptor.OfField)descriptor));
                } else {
                    b.anewarray(descriptor);
                }
            });
            return this;
        }

        public CodeContextClassFile instanceOf(ClassDesc descriptor) {
            this.codeVisitors.add(b -> b.instanceOf(descriptor));
            return this;
        }

        public CodeContextClassFile checkCast(ClassDesc descriptor) {
            this.codeVisitors.add(b -> b.checkcast(descriptor));
            return this;
        }

        public CodeContextClassFile returnValue(ClassDesc descriptor) {
            this.codeVisitors.add(b -> b.return_(TypeKind.from((TypeDescriptor.OfField)descriptor)));
            return this;
        }

        public CodeContextClassFile field(DirectMethodHandleDesc.Kind operation, ClassDesc owner, String name, ClassDesc descriptor) {
            this.codeVisitors.add(b -> b.fieldAccess(switch (operation) {
                case DirectMethodHandleDesc.Kind.STATIC_GETTER -> Opcode.GETSTATIC;
                case DirectMethodHandleDesc.Kind.STATIC_SETTER -> Opcode.PUTSTATIC;
                case DirectMethodHandleDesc.Kind.GETTER -> Opcode.GETFIELD;
                case DirectMethodHandleDesc.Kind.SETTER -> Opcode.PUTFIELD;
                default -> throw new IllegalArgumentException("Invalid field operation: " + String.valueOf((Object)operation));
            }, owner, name, descriptor));
            return this;
        }

        public CodeContextClassFile method(DirectMethodHandleDesc.Kind operation, ClassDesc owner, String name, MethodTypeDesc descriptor) {
            if (operation == DirectMethodHandleDesc.Kind.CONSTRUCTOR) {
                if (!"<init>".equals(name)) {
                    throw new IllegalArgumentException("CONSTRUCTOR must be used with <init> method");
                }
                return this.newInstance(owner, descriptor);
            }
            this.codeVisitors.add(b -> b.invoke(switch (operation) {
                case DirectMethodHandleDesc.Kind.STATIC, DirectMethodHandleDesc.Kind.INTERFACE_STATIC -> Opcode.INVOKESTATIC;
                case DirectMethodHandleDesc.Kind.VIRTUAL -> Opcode.INVOKEVIRTUAL;
                case DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL -> Opcode.INVOKEINTERFACE;
                case DirectMethodHandleDesc.Kind.SPECIAL, DirectMethodHandleDesc.Kind.INTERFACE_SPECIAL -> Opcode.INVOKESPECIAL;
                default -> throw new IllegalArgumentException("Invalid method operation: " + String.valueOf((Object)operation));
            }, owner, name, descriptor, operation.isInterface));
            return this;
        }

        public CodeContextClassFile newInstance(ClassDesc owner, MethodTypeDesc constructorDescriptor) {
            this.codeVisitors.add(b -> {
                b.new_(owner);
                b.dup();
                b.invoke(Opcode.INVOKESPECIAL, owner, "<init>", constructorDescriptor, false);
            });
            return this;
        }

        public CodeContextClassFile invokeDynamic(String name, MethodTypeDesc descriptor, DirectMethodHandleDesc bootstrap, Collection<ConstantDesc> bootstrapArguments) {
            this.codeVisitors.add(b -> {
                ConstantDesc[] args = (ConstantDesc[])bootstrapArguments.toArray(ConstantDesc[]::new);
                b.invokedynamic(DynamicCallSiteDesc.of(bootstrap, name, descriptor, args));
            });
            return this;
        }

        public CodeContextClassFile jump(Opcode instruction, Consumer<? super CodeContextClassFile> skip) {
            this.codeVisitors.add(b -> {
                Label label = b.newLabel();
                b.branch(instruction, label);
                CodeContextClassFile skipContext = new CodeContextClassFile();
                skip.accept(skipContext);
                skipContext.apply((CodeBuilder)b);
                b.labelBinding(label);
            });
            return this;
        }

        public CodeContextClassFile loadThis() {
            this.codeVisitors.add(b -> b.loadLocal(TypeKind.REFERENCE, 0));
            return this;
        }
    }
}

