/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.bytecodebuilder;

import dev.lukebemish.bytecodebuilder.Signature;

public final class ClassSignature {
    private final String signature;

    private ClassSignature(String signature) {
        this.signature = signature;
    }

    public String signature() {
        return this.signature;
    }

    public Builder create() {
        return new Builder();
    }

    public static final class Builder {
        private final StringBuilder signature = new StringBuilder();

        public Builder typeParameter(String name, Signature classBound, Signature ... interfaceBounds) {
            this.signature.append(name);
            this.signature.append(':').append(classBound.signature());
            for (Signature interfaceBound : interfaceBounds) {
                this.signature.append(':').append(interfaceBound.signature());
            }
            return this;
        }

        public ClassSignature build(Signature superClass, Signature ... interfaces) {
            StringBuilder full = new StringBuilder();
            if (!this.signature.isEmpty()) {
                full.append('<').append((CharSequence)this.signature).append('>');
            }
            this.signature.append(superClass.signature());
            for (Signature interfaceSignature : interfaces) {
                full.append(interfaceSignature.signature());
            }
            return new ClassSignature(full.toString());
        }
    }
}

