/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.bytecodebuilder.runtime;

import dev.lukebemish.bytecodebuilder.runtime.FlexibleLambdaMetafactory;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class Coercion {
    private Coercion() {
    }

    public static <T> T coerce(MethodHandle handle, Class<T> targetSamClass) throws LambdaConversionException {
        Method method = Coercion.findAbstractMethod(targetSamClass);
        MethodType samMethodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        CallSite callsite = FlexibleLambdaMetafactory.metafactory(MethodHandles.lookup(), method.getName(), MethodType.methodType(targetSamClass), samMethodType, handle, samMethodType);
        try {
            return (T)callsite.dynamicInvoker().invoke();
        }
        catch (Throwable e) {
            throw new LambdaConversionException(e);
        }
    }

    public static <F> F coerceCapturing(MethodHandle handle, Class<?> targetSamClass, Class<F> targetFactoryClass) throws LambdaConversionException {
        MethodHandle factoryHandle = Coercion.coerceCapturing(handle, targetSamClass);
        return Coercion.coerce(factoryHandle, targetFactoryClass);
    }

    public static MethodHandle coerceCapturing(MethodHandle handle, Class<?> targetSamClass) throws LambdaConversionException {
        Method method = Coercion.findAbstractMethod(targetSamClass);
        MethodType samMethodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        int capturedArgArity = handle.type().parameterCount() - samMethodType.parameterCount();
        Class[] ctorArgs = new Class[capturedArgArity];
        for (int i = 0; i < capturedArgArity; ++i) {
            ctorArgs[i] = handle.type().parameterType(i);
        }
        MethodType targetType = MethodType.methodType(targetSamClass, ctorArgs);
        CallSite callsite = FlexibleLambdaMetafactory.metafactory(MethodHandles.lookup(), method.getName(), targetType, samMethodType, handle, samMethodType);
        return callsite.dynamicInvoker();
    }

    private static Method findAbstractMethod(Class<?> targetSamClass) {
        final AtomicReference found = new AtomicReference();
        final HashSet checked = new HashSet();
        Consumer addAbstractMethods = new Consumer<Class<?>>(){

            @Override
            public void accept(Class<?> cls) {
                for (Method method : cls.getDeclaredMethods()) {
                    Method existing;
                    String tag;
                    if (method.accessFlags().contains((Object)AccessFlag.STATIC) || checked.contains(tag = method.getName() + MethodType.methodType(method.getReturnType(), method.getParameterTypes()).descriptorString())) continue;
                    checked.add(tag);
                    if (!method.accessFlags().contains((Object)AccessFlag.ABSTRACT) || (existing = found.getAndSet(method)) == null) continue;
                    throw new IllegalArgumentException("Found two abstract methods in " + cls.getName() + ": " + String.valueOf(existing) + " and " + String.valueOf(method));
                }
                for (GenericDeclaration genericDeclaration : cls.getInterfaces()) {
                    this.accept((Class<?>)genericDeclaration);
                }
                Class<?> superClass = cls.getSuperclass();
                if (superClass != null && superClass != Object.class) {
                    this.accept(superClass);
                }
            }
        };
        addAbstractMethods.accept(targetSamClass);
        Method method = (Method)found.get();
        if (method == null) {
            throw new IllegalArgumentException("No abstract method found in " + targetSamClass.getName());
        }
        return method;
    }
}

