/*
 * Decompiled with CFR 0.152.
 */
package dev.postproxy.sdk.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.postproxy.sdk.PostProxyClient;
import dev.postproxy.sdk.model.DeleteResponse;
import dev.postproxy.sdk.model.PaginatedResponse;
import dev.postproxy.sdk.model.Post;
import dev.postproxy.sdk.param.CreatePostParams;
import dev.postproxy.sdk.param.ListPostsParams;
import dev.postproxy.sdk.param.PlatformParams;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PostsResource {
    private final PostProxyClient client;

    public PostsResource(PostProxyClient client) {
        this.client = client;
    }

    public PaginatedResponse<Post> list() {
        return this.list(null);
    }

    public PaginatedResponse<Post> list(ListPostsParams params) {
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        String pgId = this.client.getDefaultProfileGroupId();
        if (params != null) {
            if (params.page() != null) {
                query.put("page", params.page().toString());
            }
            if (params.perPage() != null) {
                query.put("per_page", params.perPage().toString());
            }
            if (params.status() != null) {
                query.put("status", params.status().getValue());
            }
            if (params.platforms() != null && !params.platforms().isEmpty()) {
                query.put("platforms", params.platforms().stream().map(p -> p.getValue()).collect(Collectors.joining(",")));
            }
            if (params.scheduledAfter() != null) {
                query.put("scheduled_at", params.scheduledAfter());
            }
            if (params.profileGroupId() != null) {
                pgId = params.profileGroupId();
            }
        }
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        return this.client.get("/api/posts", query, new TypeReference<PaginatedResponse<Post>>(){});
    }

    public Post get(String id) {
        return this.get(id, null);
    }

    public Post get(String id, String profileGroupId) {
        String pgId;
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        String string = pgId = profileGroupId != null ? profileGroupId : this.client.getDefaultProfileGroupId();
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        return this.client.get("/api/posts/" + id, query, new TypeReference<Post>(){});
    }

    public Post create(CreatePostParams params) {
        String pgId = params.profileGroupId() != null ? params.profileGroupId() : this.client.getDefaultProfileGroupId();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        if (params.mediaFiles() != null && !params.mediaFiles().isEmpty()) {
            return this.createMultipart(params, query);
        }
        return this.createJson(params, query);
    }

    private Post createJson(CreatePostParams params, Map<String, String> query) {
        LinkedHashMap<String, Object> postMap = new LinkedHashMap<String, Object>();
        postMap.put("body", params.body());
        if (params.scheduledAt() != null) {
            postMap.put("scheduled_at", params.scheduledAt());
        }
        if (params.draft() != null) {
            postMap.put("draft", params.draft());
        }
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("post", postMap);
        body.put("profiles", params.profiles());
        if (params.media() != null && !params.media().isEmpty()) {
            body.put("media", params.media());
        }
        if (params.platforms() != null) {
            body.put("platforms", params.platforms());
        }
        return this.client.post("/api/posts", query, body, new TypeReference<Post>(){});
    }

    private Post createMultipart(CreatePostParams params, Map<String, String> query) {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        fields.put("post[body]", params.body());
        if (params.scheduledAt() != null) {
            fields.put("post[scheduled_at]", params.scheduledAt());
        }
        if (params.draft() != null) {
            fields.put("post[draft]", params.draft().toString());
        }
        fields.put("profiles[]", params.profiles());
        if (params.platforms() != null) {
            this.addPlatformFields(fields, params.platforms());
        }
        return this.client.postMultipart("/api/posts", query, fields, params.mediaFiles(), new TypeReference<Post>(){});
    }

    private void addPlatformFields(Map<String, Object> fields, PlatformParams platforms) {
        try {
            Map map = (Map)this.client.getObjectMapper().convertValue((Object)platforms, Map.class);
            for (Map.Entry platformEntry : map.entrySet()) {
                String platformName = (String)platformEntry.getKey();
                Object object = platformEntry.getValue();
                if (!(object instanceof Map)) continue;
                Map paramMap = (Map)object;
                for (Map.Entry entry : paramMap.entrySet()) {
                    String key = "platforms[" + platformName + "][" + String.valueOf(entry.getKey()) + "]";
                    Object value = entry.getValue();
                    if (value instanceof List) {
                        List list = (List)value;
                        fields.put(key + "[]", list);
                        continue;
                    }
                    fields.put(key, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Post publishDraft(String id) {
        return this.publishDraft(id, null);
    }

    public Post publishDraft(String id, String profileGroupId) {
        String pgId;
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        String string = pgId = profileGroupId != null ? profileGroupId : this.client.getDefaultProfileGroupId();
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        return this.client.post("/api/posts/" + id + "/publish", query, null, new TypeReference<Post>(){});
    }

    public DeleteResponse delete(String id) {
        return this.delete(id, null);
    }

    public DeleteResponse delete(String id, String profileGroupId) {
        String pgId;
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        String string = pgId = profileGroupId != null ? profileGroupId : this.client.getDefaultProfileGroupId();
        if (pgId != null) {
            query.put("profile_group_id", pgId);
        }
        return this.client.delete("/api/posts/" + id, query, new TypeReference<DeleteResponse>(){});
    }
}

