/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol;

import dev.qixils.crowdcontrol.SocketManager;
import dev.qixils.crowdcontrol.Subscribe;
import dev.qixils.crowdcontrol.socket.Request;
import dev.qixils.crowdcontrol.socket.Response;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import org.jetbrains.annotations.NotNull;

public final class CrowdControl {
    private final Map<String, Function<Request, Response>> effectHandlers = new HashMap<String, Function<Request, Response>>();
    private final Map<String, Consumer<Request>> asyncHandlers = new HashMap<String, Consumer<Request>>();
    private final List<Supplier<Boolean>> globalChecks = new ArrayList<Supplier<Boolean>>();
    private final String IP;
    private final int port;
    private final SocketManager socketManager;
    private static final Logger logger = Logger.getLogger("CC-Core");
    private static final Map<Class<?>, Function<Object, Response>> RETURN_TYPE_PARSERS = Map.of(Response.class, response -> (Response)response, Response.ResultType.class, type -> Response.builder().type((Response.ResultType)((Object)((Object)type))).build(), Response.Builder.class, builder -> ((Response.Builder)builder).build());

    @CheckReturnValue
    public CrowdControl(int port) {
        this("localhost", port);
    }

    @CheckReturnValue
    public CrowdControl(@NotNull String IP, int port) {
        this.IP = Objects.requireNonNull(IP, "IP");
        this.port = port;
        this.socketManager = new SocketManager(this);
    }

    @CheckReturnValue
    @NotNull
    public String getIP() {
        return this.IP;
    }

    @CheckReturnValue
    public int getPort() {
        return this.port;
    }

    private void methodHandlerWarning(@NotNull Method method, @NotNull String errorDescription) {
        logger.warning("Method " + method + " is improperly configured: " + errorDescription);
    }

    public void registerHandlers(@NotNull Object object) {
        Class<?> clazz = Objects.requireNonNull(object, "object").getClass();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(Subscribe.class)) continue;
            String nullableEffect = method.getAnnotation(Subscribe.class).effect();
            if (nullableEffect == null) {
                this.methodHandlerWarning(method, "effect name is null");
                continue;
            }
            String effect = nullableEffect.toLowerCase(Locale.ENGLISH);
            if (this.effectHandlers.containsKey(effect) || this.asyncHandlers.containsKey(effect)) {
                this.methodHandlerWarning(method, "handler by the name '" + effect + "' is already registered");
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                this.methodHandlerWarning(method, "should be public");
                continue;
            }
            Parameter[] params = method.getParameters();
            if (params.length != 1) {
                this.methodHandlerWarning(method, "expected 1 input parameter, received " + params.length);
                continue;
            }
            Class<?> paramType = params[0].getType();
            if (!Request.class.equals(paramType)) {
                this.methodHandlerWarning(method, "expected input parameter of type Request, received " + paramType.getName());
                continue;
            }
            Class<?> returnType = method.getReturnType();
            if (RETURN_TYPE_PARSERS.containsKey(returnType)) {
                Function<Object, Response> parser = RETURN_TYPE_PARSERS.get(returnType);
                this.registerHandler(effect, (Request request) -> {
                    Response output;
                    try {
                        Object result = method.invoke(object, request);
                        output = result == null ? Response.builder().type(Response.ResultType.FAILURE).message("Effect handler returned a null response").build() : (Response)parser.apply(result);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        logger.log(Level.WARNING, "Failed to invoke method handler for effect \"" + effect + "\"", e);
                        output = Response.builder().type(Response.ResultType.FAILURE).message("Failed to invoke method handler").build();
                    }
                    return output;
                });
                continue;
            }
            if (returnType == Void.class) {
                this.registerHandler(effect, (Request request) -> {
                    try {
                        method.invoke(object, request);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        logger.log(Level.WARNING, "Failed to invoke method handler for effect \"" + effect + "\"", e);
                        this.dispatchResponse(Response.builder().type(Response.ResultType.FAILURE).message("Failed to invoke method handler").build());
                    }
                });
                continue;
            }
            this.methodHandlerWarning(method, "unknown return type: " + returnType.getName());
        }
    }

    public void registerHandler(@NotNull String effect, @NotNull Function<Request, Response> handler) {
        if (this.effectHandlers.containsKey(effect = Objects.requireNonNull(effect, "effect").toLowerCase(Locale.ENGLISH)) || this.asyncHandlers.containsKey(effect)) {
            throw new IllegalArgumentException("The effect \"" + effect + "\" already has a handler.");
        }
        this.effectHandlers.put(effect, Objects.requireNonNull(handler, "handler"));
    }

    public void registerHandler(@NotNull String effect, @NotNull Consumer<Request> handler) {
        if (this.effectHandlers.containsKey(effect = Objects.requireNonNull(effect, "effect").toLowerCase(Locale.ENGLISH)) || this.asyncHandlers.containsKey(effect)) {
            throw new IllegalArgumentException("The effect \"" + effect + "\" already has a handler.");
        }
        this.asyncHandlers.put(effect, Objects.requireNonNull(handler, "handler"));
    }

    public void registerCheck(@NotNull Supplier<Boolean> check) {
        this.globalChecks.add(Objects.requireNonNull(check, "check"));
    }

    public void handle(@NotNull Request request) {
        for (Supplier<Boolean> check : this.globalChecks) {
            if (check.get().booleanValue()) continue;
            this.dispatchResponse(Response.builder().type(Response.ResultType.FAILURE).message("The game is unavailable").build());
        }
        String effect = Objects.requireNonNull(request, "request").getEffect();
        try {
            if (this.effectHandlers.containsKey(effect)) {
                this.dispatchResponse(this.effectHandlers.get(effect).apply(request));
            } else if (this.asyncHandlers.containsKey(effect)) {
                this.asyncHandlers.get(effect).accept(request);
            } else {
                this.dispatchResponse(Response.builder().type(Response.ResultType.UNAVAILABLE).message("The effect couldn't be found").build());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to handle effect \"" + effect + "\"", e);
            this.dispatchResponse(Response.builder().type(Response.ResultType.FAILURE).message("The effect encountered an exception").build());
        }
    }

    public void dispatchResponse(@NotNull Response response) {
        this.socketManager.sendResponse(response);
    }

    public void dispatchResponse(@NotNull Response.Builder response) {
        this.dispatchResponse(Objects.requireNonNull(response, "response cannot be null").build());
    }

    public void shutdown() {
        try {
            this.socketManager.shutdown();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Encountered an exception while shutting down socket", e);
        }
    }
}

