/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol;

import dev.qixils.crowdcontrol.CrowdControl;
import dev.qixils.crowdcontrol.socket.Request;
import dev.qixils.crowdcontrol.socket.Response;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

final class SocketManager {
    private final CrowdControl crowdControl;
    private final Thread thread = new Thread(this::loop, "crowdcontrol-socket-loop");
    private final Executor effectPool = Executors.newCachedThreadPool();
    private Socket socket;
    private OutputStream output;
    private volatile boolean running = true;
    private static final Logger logger = Logger.getLogger("CC-Socket");
    private int sleep = 1;
    private boolean connected = false;

    SocketManager(CrowdControl crowdControl) {
        this.crowdControl = crowdControl;
        this.thread.start();
    }

    private void loop() {
        while (this.running) {
            try {
                this.socket = new Socket(this.crowdControl.getIP(), this.crowdControl.getPort());
                logger.info("Connected to Crowd Control server");
                this.sleep = 1;
                this.connected = true;
                InputStreamReader input = new InputStreamReader(this.socket.getInputStream());
                this.output = this.socket.getOutputStream();
                while (this.running) {
                    Request request;
                    StringBuilder sb = new StringBuilder();
                    char[] results = new char[1];
                    int bytes_read = input.read(results);
                    while (results[0] != '\u0000' && bytes_read == 1) {
                        sb.append(results[0]);
                        bytes_read = input.read(results);
                    }
                    String inJSON = sb.toString();
                    try {
                        request = Request.fromJSON(inJSON);
                    }
                    catch (Exception exc) {
                        logger.log(Level.SEVERE, "Could not parse request " + inJSON, exc);
                        break;
                    }
                    this.effectPool.execute(() -> {
                        try {
                            this.crowdControl.handle(request);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Request handler threw an exception", e);
                            this.sendResponse(Response.builder().type(Response.ResultType.FAILURE).message("Request handler threw an exception").build());
                        }
                    });
                }
                logger.info("Crowd Control socket shutting down");
            }
            catch (IOException e) {
                if (!this.running) continue;
                this.socket = null;
                this.output = null;
                String error = this.connected ? "Socket loop encountered an error" : "Could not connect to the Crowd Control server";
                IOException exc = this.connected ? e : null;
                logger.log(Level.WARNING, error + ". Reconnecting in " + this.sleep + "s", exc);
                try {
                    Thread.sleep((long)this.sleep * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.sleep *= 2;
            }
        }
    }

    boolean acceptingResponses() {
        return this.output != null;
    }

    synchronized void sendResponse(@NotNull Response response) {
        Objects.requireNonNull(response, "response cannot be null");
        if (this.output == null) {
            throw new IllegalStateException("Socket output is unavailable");
        }
        try {
            this.output.write(response.toJSON().getBytes(StandardCharsets.UTF_8));
            this.output.write(0);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to write response to socket");
        }
    }

    void shutdown() throws IOException {
        this.running = false;
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

