/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol;

import dev.qixils.crowdcontrol.CrowdControl;
import dev.qixils.crowdcontrol.socket.Request;
import dev.qixils.crowdcontrol.socket.Response;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TimedEffect {
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static final Map<String, TimedEffect> ACTIVE_EFFECTS = new HashMap<String, TimedEffect>();
    private static final Logger logger = Logger.getLogger("CC-TimedEffect");
    private long startedAt = -1L;
    private long duration;
    private boolean paused = false;
    private boolean queued = false;
    private final CrowdControl cc;
    private final String effect;
    private final int id;
    @NotNull
    private final Consumer<TimedEffect> callback;
    @Nullable
    private final Consumer<TimedEffect> completionCallback;

    @CheckReturnValue
    public TimedEffect(@NotNull CrowdControl ccAPI, int requestId, @NotNull String effect, long duration, @NotNull Consumer<TimedEffect> callback, @Nullable Consumer<TimedEffect> completionCallback) {
        this.cc = Objects.requireNonNull(ccAPI, "ccAPI cannot be null");
        this.callback = Objects.requireNonNull(callback, "callback cannot be null");
        this.completionCallback = completionCallback;
        this.duration = duration;
        this.effect = Objects.requireNonNull(effect, "effect cannot be null");
        this.id = requestId;
    }

    @CheckReturnValue
    public TimedEffect(@NotNull CrowdControl ccAPI, @NotNull Request request, long duration, @NotNull Consumer<TimedEffect> callback, @Nullable Consumer<TimedEffect> completionCallback) {
        this(ccAPI, Objects.requireNonNull(request, "request cannot be null").getId(), request.getEffect(), duration, callback, completionCallback);
    }

    @CheckReturnValue
    public TimedEffect(@NotNull CrowdControl ccAPI, int requestId, @NotNull String effect, @NotNull Duration duration, @NotNull Consumer<TimedEffect> callback, @Nullable Consumer<TimedEffect> completionCallback) {
        this(ccAPI, requestId, effect, Objects.requireNonNull(duration, "duration cannot be null").toMillis(), callback, completionCallback);
    }

    @CheckReturnValue
    public TimedEffect(@NotNull CrowdControl ccAPI, @NotNull Request request, @NotNull Duration duration, @NotNull Consumer<TimedEffect> callback, @Nullable Consumer<TimedEffect> completionCallback) {
        this(ccAPI, request, Objects.requireNonNull(duration, "duration cannot be null").toMillis(), callback, completionCallback);
    }

    @CheckReturnValue
    public long getCurrentDuration() {
        return Math.max(0L, this.duration - (System.currentTimeMillis() - this.startedAt));
    }

    public void queue() throws IllegalStateException {
        if (this.queued) {
            throw new IllegalStateException("Effect was already queued");
        }
        this.queued = true;
        TimedEffect activeEffect = ACTIVE_EFFECTS.get(this.effect);
        if (activeEffect == null || activeEffect.isComplete()) {
            this.start();
            return;
        }
        this.cc.dispatchResponse(Response.builder().id(this.id).type(Response.ResultType.RETRY).message("Timed effect is already running").build());
    }

    private void start() {
        ACTIVE_EFFECTS.put(this.effect, this);
        this.startedAt = System.currentTimeMillis();
        this.cc.dispatchResponse(Response.builder().id(this.id).type(Response.ResultType.SUCCESS).timeRemaining(this.duration).build());
        try {
            this.callback.accept(this);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception occurred during starting callback", exception);
        }
        EXECUTOR.schedule(this::tryComplete, this.duration, TimeUnit.MILLISECONDS);
    }

    public void pause() throws IllegalStateException {
        if (this.paused) {
            throw new IllegalStateException("Effect is already paused");
        }
        this.startedAt = -1L;
        this.duration = this.getCurrentDuration();
        if (this.duration <= 0L) {
            throw new IllegalStateException("Effect has already completed");
        }
        if (this.startedAt == -1L) {
            throw new IllegalStateException("Effect has not started");
        }
        this.paused = true;
        this.cc.dispatchResponse(Response.builder().id(this.id).type(Response.ResultType.PAUSED).timeRemaining(this.duration).build());
    }

    public void resume() throws IllegalStateException {
        if (!this.paused) {
            throw new IllegalStateException("Effect was not paused");
        }
        if (this.duration <= 0L) {
            throw new IllegalStateException("Effect has already completed");
        }
        if (this.startedAt == -1L) {
            throw new IllegalStateException("Effect has not started");
        }
        this.paused = false;
        this.startedAt = System.currentTimeMillis();
        this.cc.dispatchResponse(Response.builder().id(this.id).type(Response.ResultType.RESUMED).timeRemaining(this.duration).build());
        EXECUTOR.schedule(this::tryComplete, this.duration, TimeUnit.MILLISECONDS);
    }

    public boolean complete() {
        if (this.duration == -1L) {
            return false;
        }
        this.duration = -1L;
        ACTIVE_EFFECTS.remove(this.effect, this);
        this.cc.dispatchResponse(Response.builder().id(this.id).type(Response.ResultType.FINISHED).build());
        if (this.completionCallback != null) {
            try {
                this.completionCallback.accept(this);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Exception occurred during completion callback", exception);
            }
        }
        return true;
    }

    private void tryComplete() {
        if (this.getCurrentDuration() == 0L) {
            this.complete();
        }
    }

    @CheckReturnValue
    public boolean isComplete() {
        return this.getCurrentDuration() == 0L;
    }

    @CheckReturnValue
    public boolean hasStarted() {
        return this.startedAt != -1L;
    }

    @CheckReturnValue
    public int getId() {
        return this.id;
    }

    @CheckReturnValue
    public String getEffect() {
        return this.effect;
    }
}

