/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.socket;

import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import dev.qixils.crowdcontrol.socket.EnumOrdinalAdapter;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Request {
    private int id;
    @SerializedName(value="code")
    private String effect;
    private Object[] parameters;
    private String viewer;
    private Integer cost;
    private Type type;

    Request() {
    }

    @CheckReturnValue
    public Request(int id, @NotNull String effect, @Nullable Object[] parameters, @NotNull String viewer, @Nullable Integer cost, @NotNull Type type) {
        this.id = id;
        this.effect = Objects.requireNonNull(effect, "effect");
        this.parameters = Objects.requireNonNullElseGet(parameters, () -> new Object[0]);
        this.viewer = Objects.requireNonNull(viewer, "viewer");
        this.cost = cost;
        this.type = Objects.requireNonNull(type, "type");
    }

    @CheckReturnValue
    public int getId() {
        return this.id;
    }

    @CheckReturnValue
    @NotNull
    public String getEffect() {
        return this.effect;
    }

    @CheckReturnValue
    @NotNull
    public Object[] getParameters() {
        return this.parameters;
    }

    @CheckReturnValue
    @NotNull
    public String getViewer() {
        return this.viewer;
    }

    @CheckReturnValue
    @Nullable
    public Integer getCost() {
        return this.cost;
    }

    @CheckReturnValue
    @NotNull
    public Type getType() {
        return this.type;
    }

    @CheckReturnValue
    @NotNull
    public static Request fromJSON(@NotNull String json) throws JsonSyntaxException {
        return (Request)EnumOrdinalAdapter.GSON.fromJson(Objects.requireNonNull(json, "json"), Request.class);
    }

    public static enum Type {
        TEST,
        START,
        STOP;

    }
}

