/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.socket;

import com.google.gson.annotations.SerializedName;
import dev.qixils.crowdcontrol.socket.EnumOrdinalAdapter;
import dev.qixils.crowdcontrol.socket.Request;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Response {
    private final int id;
    @SerializedName(value="status")
    private final ResultType type;
    private final String message;
    private final long timeRemaining;

    @CheckReturnValue
    public Response(int id, @NotNull ResultType type, @NotNull String message, long timeRemaining) {
        this.id = id;
        this.type = Objects.requireNonNull(type, "type");
        this.message = Objects.requireNonNull(message, "message");
        this.timeRemaining = timeRemaining;
    }

    @CheckReturnValue
    public int getId() {
        return this.id;
    }

    @CheckReturnValue
    @NotNull
    public ResultType getResultType() {
        return this.type;
    }

    @CheckReturnValue
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @CheckReturnValue
    public long getTimeRemaining() {
        return this.timeRemaining;
    }

    @CheckReturnValue
    @NotNull
    public String toJSON() {
        return EnumOrdinalAdapter.GSON.toJson((Object)this);
    }

    @CheckReturnValue
    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @CheckReturnValue
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Cloneable {
        private int id;
        private ResultType type;
        private String message;
        private long timeRemaining;
        private boolean messageSet = false;

        @CheckReturnValue
        public Builder() {
        }

        @CheckReturnValue
        public Builder(@NotNull Response source) {
            Objects.requireNonNull(source, "source cannot be null");
            this.id = source.id;
            this.message = source.message;
            this.type = source.type;
            this.timeRemaining = source.timeRemaining;
        }

        @CheckReturnValue
        public Builder(@NotNull Request request) {
            this.id = Objects.requireNonNull(request, "request cannot be null").getId();
        }

        @CheckReturnValue
        public Builder(int id) {
            this.id = id;
        }

        @NotNull
        @Contract(value="_ -> this")
        public Builder id(int id) {
            this.id = id;
            return this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public Builder type(@Nullable ResultType type) {
            this.type = type;
            if (type != null && !this.messageSet) {
                this.message = type.name();
            }
            return this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public Builder message(@Nullable String message) {
            this.messageSet = true;
            this.message = message;
            return this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public Builder timeRemaining(long timeRemaining) {
            if (timeRemaining < 0L) {
                throw new IllegalArgumentException("'timeRemaining' must be positive");
            }
            this.timeRemaining = timeRemaining;
            return this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public Builder timeRemaining(@Nullable Duration timeRemaining) {
            return timeRemaining != null ? this.timeRemaining(timeRemaining.toMillis()) : this;
        }

        @NotNull
        @Contract(value="_ -> this")
        public Builder timeRemaining(@Nullable Temporal endEffectAt) {
            return endEffectAt != null ? this.timeRemaining(ChronoUnit.MILLIS.between(LocalDateTime.now(), endEffectAt)) : this;
        }

        @CheckReturnValue
        @NotNull
        public Response build() {
            return new Response(this.id, this.type, this.message, this.timeRemaining);
        }

        public Builder clone() {
            return new Builder().id(this.id).timeRemaining(this.timeRemaining).message(this.message).type(this.type);
        }
    }

    public static enum ResultType {
        SUCCESS,
        FAILURE,
        UNAVAILABLE,
        RETRY,
        QUEUE,
        RUNNING,
        PAUSED,
        RESUMED,
        FINISHED;

    }
}

