/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.graphics;

import dev.robocode.tankroyale.botapi.graphics.Color;
import dev.robocode.tankroyale.botapi.graphics.IGraphics;
import dev.robocode.tankroyale.botapi.graphics.Point;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SvgGraphics
implements IGraphics {
    private final List<String> elements = new ArrayList<String>();
    private String strokeColor = "none";
    private String fillColor = "none";
    private double strokeWidth;
    private String fontFamily = "Arial";
    private double fontSize = 12.0;

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        this.elements.add("<line x1=\"" + SvgGraphics.format(x1) + "\" y1=\"" + SvgGraphics.format(y1) + "\" x2=\"" + SvgGraphics.format(x2) + "\" y2=\"" + SvgGraphics.format(y2) + "\" stroke=\"" + this.strokeColor + "\" stroke-width=\"" + SvgGraphics.format(this.strokeWidth) + "\" />\n");
    }

    @Override
    public void drawRectangle(double x, double y, double width, double height) {
        String strokeColor = this.strokeColor.equals("none") ? "#000000" : this.strokeColor;
        double strokeWidth = this.strokeWidth == 0.0 ? 1.0 : this.strokeWidth;
        this.elements.add("<rect x=\"" + SvgGraphics.format(x) + "\" y=\"" + SvgGraphics.format(y) + "\" width=\"" + SvgGraphics.format(width) + "\" height=\"" + SvgGraphics.format(height) + "\" fill=\"none\" stroke=\"" + strokeColor + "\" stroke-width=\"" + SvgGraphics.format(strokeWidth) + "\" />\n");
    }

    @Override
    public void fillRectangle(double x, double y, double width, double height) {
        this.elements.add("<rect x=\"" + SvgGraphics.format(x) + "\" y=\"" + SvgGraphics.format(y) + "\" width=\"" + SvgGraphics.format(width) + "\" height=\"" + SvgGraphics.format(height) + "\" fill=\"" + this.fillColor + "\" stroke=\"" + this.strokeColor + "\" stroke-width=\"" + SvgGraphics.format(this.strokeWidth) + "\" />\n");
    }

    @Override
    public void drawCircle(double x, double y, double radius) {
        String strokeColor = this.strokeColor.equals("none") ? "#000000" : this.strokeColor;
        double strokeWidth = this.strokeWidth == 0.0 ? 1.0 : this.strokeWidth;
        this.elements.add("<circle cx=\"" + SvgGraphics.format(x) + "\" cy=\"" + SvgGraphics.format(y) + "\" r=\"" + SvgGraphics.format(radius) + "\" fill=\"none\" stroke=\"" + strokeColor + "\" stroke-width=\"" + SvgGraphics.format(strokeWidth) + "\" />\n");
    }

    @Override
    public void fillCircle(double x, double y, double radius) {
        this.elements.add("<circle cx=\"" + SvgGraphics.format(x) + "\" cy=\"" + SvgGraphics.format(y) + "\" r=\"" + SvgGraphics.format(radius) + "\" fill=\"" + this.fillColor + "\" stroke=\"" + this.strokeColor + "\" stroke-width=\"" + SvgGraphics.format(this.strokeWidth) + "\" />\n");
    }

    @Override
    public void drawPolygon(List<Point> points) {
        if (points == null || points.size() < 3) {
            return;
        }
        StringBuilder pointsStr = new StringBuilder();
        for (Point point : points) {
            pointsStr.append(SvgGraphics.format(point.getX())).append(",").append(SvgGraphics.format(point.getY())).append(" ");
        }
        String strokeColor = this.strokeColor.equals("none") ? "#000000" : this.strokeColor;
        double strokeWidth = this.strokeWidth == 0.0 ? 1.0 : this.strokeWidth;
        this.elements.add("<polygon points=\"" + pointsStr.toString().trim() + "\" fill=\"none\" stroke=\"" + strokeColor + "\" stroke-width=\"" + SvgGraphics.format(strokeWidth) + "\" />\n");
    }

    @Override
    public void fillPolygon(List<Point> points) {
        if (points == null || points.size() < 3) {
            return;
        }
        StringBuilder pointsStr = new StringBuilder();
        for (Point point : points) {
            pointsStr.append(SvgGraphics.format(point.getX())).append(",").append(SvgGraphics.format(point.getY())).append(" ");
        }
        this.elements.add("<polygon points=\"" + pointsStr.toString().trim() + "\" fill=\"" + this.fillColor + "\" stroke=\"" + this.strokeColor + "\" stroke-width=\"" + SvgGraphics.format(this.strokeWidth) + "\" />\n");
    }

    @Override
    public void drawText(String text, double x, double y) {
        this.elements.add("<text x=\"" + SvgGraphics.format(x) + "\" y=\"" + SvgGraphics.format(y) + "\" font-family=\"" + this.fontFamily + "\" font-size=\"" + SvgGraphics.format(this.fontSize) + "\" fill=\"" + this.strokeColor + "\" >" + text + "</text>\n");
    }

    @Override
    public void setStrokeColor(Color color) {
        this.strokeColor = color.toHexColor();
    }

    @Override
    public void setFillColor(Color color) {
        this.fillColor = color.toHexColor();
    }

    @Override
    public void setStrokeWidth(double width) {
        this.strokeWidth = width;
    }

    @Override
    public void setFont(String fontFamily, double fontSize) {
        this.fontFamily = fontFamily;
        this.fontSize = fontSize;
    }

    @Override
    public String toSvg() {
        StringBuilder svg = new StringBuilder();
        svg.append("<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 5000 5000\">\n");
        for (String element : this.elements) {
            svg.append(element);
        }
        svg.append("</svg>\n");
        return svg.toString();
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    private static String format(double value) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat df = new DecimalFormat("0.###", symbols);
        return df.format(value);
    }
}

