/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.BotException;
import dev.robocode.tankroyale.botapi.BotInfo;
import dev.robocode.tankroyale.botapi.BulletState;
import dev.robocode.tankroyale.botapi.GameSetup;
import dev.robocode.tankroyale.botapi.IBaseBot;
import dev.robocode.tankroyale.botapi.IBot;
import dev.robocode.tankroyale.botapi.InitialPosition;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletFiredEvent;
import dev.robocode.tankroyale.botapi.events.Condition;
import dev.robocode.tankroyale.botapi.events.RoundStartedEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.graphics.Color;
import dev.robocode.tankroyale.botapi.graphics.IGraphics;
import dev.robocode.tankroyale.botapi.internal.BotEventHandlers;
import dev.robocode.tankroyale.botapi.internal.EnvVars;
import dev.robocode.tankroyale.botapi.internal.EventQueue;
import dev.robocode.tankroyale.botapi.internal.GraphicsState;
import dev.robocode.tankroyale.botapi.internal.IStopResumeListener;
import dev.robocode.tankroyale.botapi.internal.InternalEventHandlers;
import dev.robocode.tankroyale.botapi.internal.RecordingPrintStream;
import dev.robocode.tankroyale.botapi.internal.ThreadInterruptedException;
import dev.robocode.tankroyale.botapi.internal.WebSocketHandler;
import dev.robocode.tankroyale.botapi.internal.json.JsonConverter;
import dev.robocode.tankroyale.botapi.util.ColorUtil;
import dev.robocode.tankroyale.botapi.util.MathUtil;
import dev.robocode.tankroyale.schema.BotIntent;
import dev.robocode.tankroyale.schema.Message;
import dev.robocode.tankroyale.schema.ServerHandshake;
import dev.robocode.tankroyale.schema.TeamMessage;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class BaseBotInternals {
    private static final String DEFAULT_SERVER_URL = "ws://localhost:7654";
    private static final String SERVER_URL_PROPERTY_KEY = "server.url";
    private static final String SERVER_SECRET_PROPERTY_KEY = "server.secret";
    private static final String NOT_CONNECTED_TO_SERVER_MSG = "Not connected to a game server. Make sure onConnected() event handler has been called first";
    private static final String GAME_NOT_RUNNING_MSG = "Game is not running. Make sure onGameStarted() event handler has been called first";
    private static final String TICK_NOT_AVAILABLE_MSG = "Game is not running or tick has not occurred yet. Make sure onTick() event handler has been called first";
    private final URI serverUrl;
    private final String serverSecret;
    private WebSocket socket;
    private ServerHandshake serverHandshake;
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    private final IBaseBot baseBot;
    private final BotInfo botInfo;
    private final BotIntent botIntent = BaseBotInternals.newBotIntent();
    private Integer myId;
    private Set<Integer> teammateIds;
    private GameSetup gameSetup;
    private InitialPosition initialPosition;
    private TickEvent tickEvent;
    private Long tickStartNanoTime;
    private final EventQueue eventQueue;
    private final BotEventHandlers botEventHandlers;
    private final InternalEventHandlers internalEventHandlers = new InternalEventHandlers();
    private final Set<Condition> conditions = new CopyOnWriteArraySet<Condition>();
    private final Object nextTurnMonitor = new Object();
    private Thread thread;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private boolean isStopped;
    private IStopResumeListener stopResumeListener;
    private double maxSpeed = 8.0;
    private double maxTurnRate = 10.0;
    private double maxGunTurnRate = 20.0;
    private double maxRadarTurnRate = 45.0;
    private Double savedTargetSpeed;
    private Double savedTurnRate;
    private Double savedGunTurnRate;
    private Double savedRadarTurnRate;
    private final double absDeceleration = Math.abs(-2);
    private int eventHandlingDisabledTurn;
    private RecordingPrintStream recordedStdOut;
    private RecordingPrintStream recordedStdErr;
    private int lastExecuteTurnNumber;
    private final GraphicsState graphicsState = new GraphicsState();

    public BaseBotInternals(IBaseBot baseBot, BotInfo botInfo, URI serverUrl, String serverSecret) {
        this.baseBot = baseBot;
        if (botInfo == null) {
            botInfo = EnvVars.getBotInfo();
        }
        this.botInfo = botInfo;
        this.botEventHandlers = new BotEventHandlers(baseBot);
        this.eventQueue = new EventQueue(this, this.botEventHandlers);
        this.serverUrl = serverUrl == null ? this.getServerUrlFromSetting() : serverUrl;
        this.serverSecret = serverSecret == null ? this.getServerSecretFromSetting() : serverSecret;
        this.init();
    }

    private void init() {
        this.redirectStdOutAndStdErr();
        this.subscribeToEvents();
    }

    private void redirectStdOutAndStdErr() {
        this.recordedStdOut = new RecordingPrintStream(System.out);
        this.recordedStdErr = new RecordingPrintStream(System.err);
        System.setOut(this.recordedStdOut);
        System.setErr(this.recordedStdErr);
    }

    private void subscribeToEvents() {
        this.internalEventHandlers.onRoundStarted.subscribe(this::onRoundStarted, 100);
        this.internalEventHandlers.onNextTurn.subscribe(this::onNextTurn, 100);
        this.internalEventHandlers.onBulletFired.subscribe(this::onBulletFired, 100);
    }

    public void setRunning(boolean isRunning) {
        this.isRunning.set(isRunning);
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    void startThread(IBot bot) {
        this.thread = new Thread(this.createRunnable(bot));
        this.thread.start();
    }

    private Runnable createRunnable(IBot bot) {
        return () -> {
            this.setRunning(true);
            try {
                this.enableEventHandling(true);
                try {
                    bot.run();
                }
                catch (ThreadInterruptedException e) {
                    this.enableEventHandling(false);
                    return;
                }
                while (this.isRunning()) {
                    try {
                        bot.go();
                    }
                    catch (ThreadInterruptedException e) {
                        this.enableEventHandling(false);
                        return;
                    }
                }
            }
            finally {
                this.enableEventHandling(false);
            }
        };
    }

    void stopThread() {
        if (!this.isRunning()) {
            return;
        }
        this.setRunning(false);
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public void enableEventHandling(boolean enable) {
        this.eventHandlingDisabledTurn = enable ? 0 : this.getCurrentTickOrThrow().getTurnNumber();
    }

    public boolean getEventHandlingDisabledTurn() {
        return this.eventHandlingDisabledTurn != 0 && this.eventHandlingDisabledTurn < this.getCurrentTickOrThrow().getTurnNumber() - 1;
    }

    void setStopResumeHandler(IStopResumeListener listener) {
        this.stopResumeListener = listener;
    }

    private static BotIntent newBotIntent() {
        BotIntent botIntent = new BotIntent();
        botIntent.setType(Message.Type.BOT_INTENT);
        return botIntent;
    }

    private void resetMovement() {
        this.botIntent.setTurnRate(null);
        this.botIntent.setGunTurnRate(null);
        this.botIntent.setRadarTurnRate(null);
        this.botIntent.setTargetSpeed(null);
        this.botIntent.setFirepower(null);
    }

    InternalEventHandlers getInstantEventHandlers() {
        return this.internalEventHandlers;
    }

    public List<BotEvent> getEvents() {
        int turnNumber = this.getCurrentTickOrThrow().getTurnNumber();
        return this.eventQueue.getEvents(turnNumber);
    }

    public void clearEvents() {
        this.eventQueue.clearEvents();
    }

    public void setInterruptible(boolean interruptible) {
        this.eventQueue.setCurrentEventInterruptible(interruptible);
    }

    Set<Condition> getConditions() {
        return this.conditions;
    }

    private void onRoundStarted(RoundStartedEvent e) {
        this.resetMovement();
        this.eventQueue.clear();
        this.isStopped = false;
        this.eventHandlingDisabledTurn = 0;
        this.lastExecuteTurnNumber = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNextTurn(TickEvent e) {
        Object object = this.nextTurnMonitor;
        synchronized (object) {
            this.nextTurnMonitor.notifyAll();
        }
    }

    private void onBulletFired(BulletFiredEvent e) {
        this.botIntent.setFirepower(0.0);
    }

    public void start() {
        this.connect();
        try {
            this.closedLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void connect() {
        BaseBotInternals.sanitizeUrl(this.serverUrl);
        try {
            HttpClient httpClient = HttpClient.newBuilder().build();
            WebSocket.Builder webSocketBuilder = httpClient.newWebSocketBuilder();
            WebSocketHandler webSocketHandler = new WebSocketHandler(this, this.serverUrl, this.serverSecret, this.baseBot, this.botInfo, this.botEventHandlers, this.internalEventHandlers, this.closedLatch);
            this.socket = webSocketBuilder.buildAsync(this.serverUrl, webSocketHandler).join();
        }
        catch (Exception ex) {
            throw new BotException("Could not create web socket for URL: " + this.serverUrl);
        }
    }

    private static void sanitizeUrl(URI uri) {
        String scheme = uri.getScheme();
        if (!List.of("ws", "wss").contains(scheme)) {
            throw new BotException("Wrong scheme used with server URL: " + uri);
        }
    }

    public void execute() {
        if (!this.isRunning()) {
            return;
        }
        int turnNumber = this.getCurrentTickOrThrow().getTurnNumber();
        if (turnNumber != this.lastExecuteTurnNumber) {
            this.lastExecuteTurnNumber = turnNumber;
            this.sendIntent();
        }
        this.waitForNextTurn(turnNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendIntent() {
        BaseBotInternals baseBotInternals = this;
        synchronized (baseBotInternals) {
            this.renderGraphicsToBotIntent();
            this.transferStdOutToBotIntent();
            this.socket.sendText(JsonConverter.toJson(this.botIntent), true);
            this.botIntent.getTeamMessages().clear();
        }
    }

    private void transferStdOutToBotIntent() {
        if (this.recordedStdOut != null) {
            String output = this.recordedStdOut.readNext();
            this.botIntent.setStdOut(output);
        }
        if (this.recordedStdErr != null) {
            String error = this.recordedStdErr.readNext();
            this.botIntent.setStdErr(error);
        }
    }

    private void renderGraphicsToBotIntent() {
        if (this.getCurrentTickOrThrow().getBotState().isDebuggingEnabled()) {
            this.botIntent.setDebugGraphics(this.graphicsState.getSvgOutput());
            this.graphicsState.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNextTurn(int turnNumber) {
        this.stopRogueThread();
        Object object = this.nextTurnMonitor;
        synchronized (object) {
            while (this.isRunning() && turnNumber == this.getCurrentTickOrThrow().getTurnNumber() && Thread.currentThread() == this.thread && !Thread.currentThread().isInterrupted()) {
                try {
                    this.nextTurnMonitor.wait();
                }
                catch (InterruptedException ex) {
                    throw new ThreadInterruptedException();
                }
            }
        }
    }

    private void stopRogueThread() {
        if (Thread.currentThread() != this.thread) {
            throw new ThreadInterruptedException();
        }
    }

    public void dispatchEvents(int turnNumber) {
        try {
            this.eventQueue.dispatchEvents(turnNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getVariant() {
        return this.getServerHandshake().getVariant();
    }

    public String getVersion() {
        return this.getServerHandshake().getVersion();
    }

    public int getMyId() {
        if (this.myId == null) {
            throw new BotException(GAME_NOT_RUNNING_MSG);
        }
        return this.myId;
    }

    void setMyId(Integer myId) {
        this.myId = myId;
    }

    public GameSetup getGameSetup() {
        if (this.gameSetup == null) {
            throw new BotException(GAME_NOT_RUNNING_MSG);
        }
        return this.gameSetup;
    }

    void setGameSetup(GameSetup gameSetup) {
        this.gameSetup = gameSetup;
    }

    public InitialPosition getInitialPosition() {
        return this.initialPosition;
    }

    void setInitialPosition(InitialPosition initialPosition) {
        this.initialPosition = initialPosition;
    }

    public BotIntent getBotIntent() {
        return this.botIntent;
    }

    public TickEvent getCurrentTickOrThrow() {
        if (this.tickEvent == null) {
            throw new BotException(TICK_NOT_AVAILABLE_MSG);
        }
        return this.tickEvent;
    }

    public TickEvent getCurrentTickOrNull() {
        return this.tickEvent;
    }

    void setTickEvent(TickEvent tickEvent) {
        this.tickEvent = tickEvent;
    }

    private long getTicksStart() {
        if (this.tickStartNanoTime == null) {
            throw new BotException(TICK_NOT_AVAILABLE_MSG);
        }
        return this.tickStartNanoTime;
    }

    void setTickStartNanoTime(Long tickStartNanoTime) {
        this.tickStartNanoTime = tickStartNanoTime;
    }

    void addEventsFromTick(TickEvent event) {
        this.eventQueue.addEventsFromTick(event);
    }

    public int getTimeLeft() {
        long passesMicroSeconds = (System.nanoTime() - this.getTicksStart()) / 1000L;
        return (int)((long)this.getGameSetup().getTurnTimeout() - passesMicroSeconds);
    }

    public boolean setFire(double firepower) {
        if (Double.isNaN(firepower)) {
            throw new IllegalArgumentException("'firepower' cannot be NaN");
        }
        if (this.baseBot.getEnergy() < firepower || this.baseBot.getGunHeat() > 0.0) {
            return false;
        }
        this.botIntent.setFirepower(firepower);
        return true;
    }

    public double getGunHeat() {
        return this.tickEvent == null ? 0.0 : this.tickEvent.getBotState().getGunHeat();
    }

    public double getSpeed() {
        return this.tickEvent == null ? 0.0 : this.tickEvent.getBotState().getSpeed();
    }

    public void setTurnRate(double turnRate) {
        if (Double.isNaN(turnRate)) {
            throw new IllegalArgumentException("'turnRate' cannot be NaN");
        }
        this.botIntent.setTurnRate(MathUtil.clamp(turnRate, -this.maxTurnRate, this.maxTurnRate));
    }

    public void setGunTurnRate(double gunTurnRate) {
        if (Double.isNaN(gunTurnRate)) {
            throw new IllegalArgumentException("'gunTurnRate' cannot be NaN");
        }
        this.botIntent.setGunTurnRate(MathUtil.clamp(gunTurnRate, -this.maxGunTurnRate, this.maxGunTurnRate));
    }

    public void setRadarTurnRate(double radarTurnRate) {
        if (Double.isNaN(radarTurnRate)) {
            throw new IllegalArgumentException("'radarTurnRate' cannot be NaN");
        }
        this.botIntent.setRadarTurnRate(MathUtil.clamp(radarTurnRate, -this.maxRadarTurnRate, this.maxRadarTurnRate));
    }

    public void setTargetSpeed(double targetSpeed) {
        if (Double.isNaN(targetSpeed)) {
            throw new IllegalArgumentException("'targetSpeed' cannot be NaN");
        }
        this.botIntent.setTargetSpeed(MathUtil.clamp(targetSpeed, -this.maxSpeed, this.maxSpeed));
    }

    public double getTurnRate() {
        if (this.botIntent.getTurnRate() != null) {
            return this.botIntent.getTurnRate();
        }
        return this.tickEvent == null ? 0.0 : this.tickEvent.getBotState().getTurnRate();
    }

    public double getGunTurnRate() {
        if (this.botIntent.getGunTurnRate() != null) {
            return this.botIntent.getGunTurnRate();
        }
        return this.tickEvent == null ? 0.0 : this.tickEvent.getBotState().getGunTurnRate();
    }

    public double getRadarTurnRate() {
        if (this.botIntent.getRadarTurnRate() != null) {
            return this.botIntent.getRadarTurnRate();
        }
        return this.tickEvent == null ? 0.0 : this.tickEvent.getBotState().getRadarTurnRate();
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(double maxSpeed) {
        this.maxSpeed = MathUtil.clamp(maxSpeed, 0.0, 8.0);
    }

    public double getMaxTurnRate() {
        return this.maxTurnRate;
    }

    public void setMaxTurnRate(double maxTurnRate) {
        this.maxTurnRate = MathUtil.clamp(maxTurnRate, 0.0, 10.0);
    }

    public double getMaxGunTurnRate() {
        return this.maxGunTurnRate;
    }

    public void setMaxGunTurnRate(double maxGunTurnRate) {
        this.maxGunTurnRate = MathUtil.clamp(maxGunTurnRate, 0.0, 20.0);
    }

    public double getMaxRadarTurnRate() {
        return this.maxRadarTurnRate;
    }

    public void setMaxRadarTurnRate(double maxRadarTurnRate) {
        this.maxRadarTurnRate = MathUtil.clamp(maxRadarTurnRate, 0.0, 45.0);
    }

    double getNewTargetSpeed(double speed, double distance) {
        if (distance < 0.0) {
            return -this.getNewTargetSpeed(-speed, -distance);
        }
        double targetSpeed = distance == Double.POSITIVE_INFINITY ? this.maxSpeed : Math.min(this.maxSpeed, this.getMaxSpeed(distance));
        return speed >= 0.0 ? MathUtil.clamp(targetSpeed, speed - this.absDeceleration, speed + 1.0) : MathUtil.clamp(targetSpeed, speed - 1.0, speed + this.getMaxDeceleration(-speed));
    }

    private double getMaxSpeed(double distance) {
        double decelerationTime = Math.max(1.0, Math.ceil((Math.sqrt(8.0 / this.absDeceleration * distance + 1.0) - 1.0) / 2.0));
        if (decelerationTime == Double.POSITIVE_INFINITY) {
            return 8.0;
        }
        double decelerationDistance = decelerationTime / 2.0 * (decelerationTime - 1.0) * this.absDeceleration;
        return (decelerationTime - 1.0) * this.absDeceleration + (distance - decelerationDistance) / decelerationTime;
    }

    private double getMaxDeceleration(double speed) {
        double decelerationTime = speed / this.absDeceleration;
        double accelerationTime = 1.0 - decelerationTime;
        return Math.min(1.0, decelerationTime) * this.absDeceleration + Math.max(0.0, accelerationTime) * 1.0;
    }

    double getDistanceTraveledUntilStop(double speed) {
        speed = Math.abs(speed);
        double distance = 0.0;
        while (speed > 0.0) {
            speed = this.getNewTargetSpeed(speed, 0.0);
            distance += speed;
        }
        return distance;
    }

    public boolean addCondition(Condition condition) {
        return this.conditions.add(condition);
    }

    public boolean removeCondition(Condition condition) {
        return this.conditions.remove(condition);
    }

    public void setStop(boolean overwrite) {
        if (!this.isStopped || overwrite) {
            this.isStopped = true;
            this.savedTargetSpeed = this.botIntent.getTargetSpeed();
            this.savedTurnRate = this.botIntent.getTurnRate();
            this.savedGunTurnRate = this.botIntent.getGunTurnRate();
            this.savedRadarTurnRate = this.botIntent.getRadarTurnRate();
            this.botIntent.setTargetSpeed(0.0);
            this.botIntent.setTurnRate(0.0);
            this.botIntent.setGunTurnRate(0.0);
            this.botIntent.setRadarTurnRate(0.0);
            if (this.stopResumeListener != null) {
                this.stopResumeListener.onStop();
            }
        }
    }

    public void setResume() {
        if (this.isStopped) {
            this.botIntent.setTargetSpeed(this.savedTargetSpeed);
            this.botIntent.setTurnRate(this.savedTurnRate);
            this.botIntent.setGunTurnRate(this.savedGunTurnRate);
            this.botIntent.setRadarTurnRate(this.savedRadarTurnRate);
            if (this.stopResumeListener != null) {
                this.stopResumeListener.onResume();
            }
            this.isStopped = false;
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public Set<Integer> getTeammateIds() {
        if (this.teammateIds == null) {
            throw new BotException(GAME_NOT_RUNNING_MSG);
        }
        return this.teammateIds;
    }

    void setTeammateIds(Set<Integer> teammateIds) {
        this.teammateIds = teammateIds;
    }

    public boolean isTeammate(int botId) {
        return this.getTeammateIds().stream().anyMatch(teammateId -> botId == teammateId);
    }

    public void broadcastTeamMessage(Object message) {
        this.sendTeamMessage(null, message);
    }

    public void sendTeamMessage(Integer teammateId, Object message) {
        if (teammateId != null && !this.getTeammateIds().contains(teammateId)) {
            throw new IllegalArgumentException("No teammate was found with the specified 'teammateId': " + teammateId);
        }
        if (this.botIntent.getTeamMessages().size() == 10) {
            throw new BotException("The maximum number team massages has already been reached: 10");
        }
        if (message == null) {
            throw new IllegalArgumentException("The 'message' of a team message cannot be null");
        }
        String json = JsonConverter.toJson(message);
        if (json.getBytes().length > 32768) {
            throw new IllegalArgumentException("The team message is larger than the limit of 32768 bytes (compact JSON format)");
        }
        TeamMessage teamMessage = new TeamMessage();
        teamMessage.setMessageType(message.getClass().getName());
        teamMessage.setReceiverId(teammateId);
        teamMessage.setMessage(json);
        this.botIntent.getTeamMessages().add(teamMessage);
    }

    public Color getBodyColor() {
        return this.tickEvent == null ? null : this.tickEvent.getBotState().getBodyColor();
    }

    public Color getTurretColor() {
        return this.tickEvent == null ? null : this.tickEvent.getBotState().getTurretColor();
    }

    public Color getRadarColor() {
        return this.tickEvent == null ? null : this.tickEvent.getBotState().getRadarColor();
    }

    public Color getBulletColor() {
        return this.tickEvent == null ? null : this.tickEvent.getBotState().getBulletColor();
    }

    public Color getScanColor() {
        return this.tickEvent == null ? null : this.tickEvent.getBotState().getScanColor();
    }

    public Color getTracksColor() {
        return this.tickEvent == null ? null : this.tickEvent.getBotState().getTracksColor();
    }

    public Color getGunColor() {
        return this.tickEvent == null ? null : this.tickEvent.getBotState().getGunColor();
    }

    public void setBodyColor(Color color) {
        this.botIntent.setBodyColor(BaseBotInternals.toIntentColor(color));
    }

    public void setTurretColor(Color color) {
        this.botIntent.setTurretColor(BaseBotInternals.toIntentColor(color));
    }

    public void setRadarColor(Color color) {
        this.botIntent.setRadarColor(BaseBotInternals.toIntentColor(color));
    }

    public void setBulletColor(Color color) {
        this.botIntent.setBulletColor(BaseBotInternals.toIntentColor(color));
    }

    public void setScanColor(Color color) {
        this.botIntent.setScanColor(BaseBotInternals.toIntentColor(color));
    }

    public void setTracksColor(Color color) {
        this.botIntent.setTracksColor(BaseBotInternals.toIntentColor(color));
    }

    public void setGunColor(Color color) {
        this.botIntent.setGunColor(BaseBotInternals.toIntentColor(color));
    }

    public IGraphics getGraphics() {
        return this.graphicsState.getGraphics();
    }

    private static String toIntentColor(Color color) {
        return color == null ? null : "#" + ColorUtil.toHex(color);
    }

    public Collection<BulletState> getBulletStates() {
        return this.tickEvent == null ? Collections.emptySet() : this.tickEvent.getBulletStates();
    }

    private ServerHandshake getServerHandshake() {
        if (this.serverHandshake == null) {
            throw new BotException(NOT_CONNECTED_TO_SERVER_MSG);
        }
        return this.serverHandshake;
    }

    void setServerHandshake(ServerHandshake serverHandshake) {
        this.serverHandshake = serverHandshake;
    }

    private URI getServerUrlFromSetting() {
        String url = System.getProperty(SERVER_URL_PROPERTY_KEY);
        if (url == null) {
            url = EnvVars.getServerUrl();
        }
        if (url == null) {
            url = DEFAULT_SERVER_URL;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new BotException("Incorrect syntax for server URL: " + url + ". Default is: ws://localhost:7654");
        }
    }

    private String getServerSecretFromSetting() {
        String secret = System.getProperty(SERVER_SECRET_PROPERTY_KEY);
        if (secret == null) {
            secret = EnvVars.getServerSecret();
        }
        return secret;
    }
}

