/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletFiredEvent;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.DisconnectedEvent;
import dev.robocode.tankroyale.botapi.events.GameEndedEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.HitWallEvent;
import dev.robocode.tankroyale.botapi.events.IEvent;
import dev.robocode.tankroyale.botapi.events.RoundEndedEvent;
import dev.robocode.tankroyale.botapi.events.RoundStartedEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.EventHandler;
import java.util.HashMap;
import java.util.Map;

final class InternalEventHandlers {
    final EventHandler<DisconnectedEvent> onDisconnected = new EventHandler();
    final EventHandler<GameEndedEvent> onGameEnded = new EventHandler();
    final EventHandler<GameAbortedEvent> onGameAborted = new EventHandler();
    final EventHandler<RoundStartedEvent> onRoundStarted = new EventHandler();
    final EventHandler<RoundEndedEvent> onRoundEnded = new EventHandler();
    final EventHandler<DeathEvent> onDeath = new EventHandler();
    final EventHandler<HitBotEvent> onHitBot = new EventHandler();
    final EventHandler<HitWallEvent> onHitWall = new EventHandler();
    final EventHandler<BulletFiredEvent> onBulletFired = new EventHandler();
    final EventHandler<TickEvent> onNextTurn = new EventHandler();
    private final Map<Class<? extends IEvent>, EventHandler<? extends IEvent>> eventHandlerMap = new HashMap<Class<? extends IEvent>, EventHandler<? extends IEvent>>();

    InternalEventHandlers() {
        this.initializeEventHandlers();
    }

    private void initializeEventHandlers() {
        this.eventHandlerMap.put(DisconnectedEvent.class, this.onDisconnected);
        this.eventHandlerMap.put(GameEndedEvent.class, this.onGameEnded);
        this.eventHandlerMap.put(GameAbortedEvent.class, this.onGameAborted);
        this.eventHandlerMap.put(RoundStartedEvent.class, this.onRoundStarted);
        this.eventHandlerMap.put(RoundEndedEvent.class, this.onRoundEnded);
        this.eventHandlerMap.put(DeathEvent.class, this.onDeath);
        this.eventHandlerMap.put(HitBotEvent.class, this.onHitBot);
        this.eventHandlerMap.put(HitWallEvent.class, this.onHitWall);
        this.eventHandlerMap.put(BulletFiredEvent.class, this.onBulletFired);
        this.eventHandlerMap.put(NextTurnEvent.class, this.onNextTurn);
    }

    void fireEvent(BotEvent event) {
        EventHandler<? extends IEvent> handler = this.eventHandlerMap.get(event.getClass());
        if (handler != null) {
            handler.publish(event);
        }
    }

    private static final class NextTurnEvent
    implements IEvent {
        private NextTurnEvent() {
        }
    }

    public static final class GameAbortedEvent
    implements IEvent {
    }
}

