/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.mapper;

import dev.robocode.tankroyale.botapi.BotException;
import dev.robocode.tankroyale.botapi.BulletState;
import dev.robocode.tankroyale.botapi.IBaseBot;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitWallEvent;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.HitByBulletEvent;
import dev.robocode.tankroyale.botapi.events.HitWallEvent;
import dev.robocode.tankroyale.botapi.events.ScannedBotEvent;
import dev.robocode.tankroyale.botapi.events.SkippedTurnEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.json.JsonConverter;
import dev.robocode.tankroyale.botapi.mapper.BotStateMapper;
import dev.robocode.tankroyale.botapi.mapper.BulletStateMapper;
import dev.robocode.tankroyale.schema.BotDeathEvent;
import dev.robocode.tankroyale.schema.BotHitBotEvent;
import dev.robocode.tankroyale.schema.BotHitWallEvent;
import dev.robocode.tankroyale.schema.BulletFiredEvent;
import dev.robocode.tankroyale.schema.BulletHitBotEvent;
import dev.robocode.tankroyale.schema.BulletHitBulletEvent;
import dev.robocode.tankroyale.schema.Event;
import dev.robocode.tankroyale.schema.TeamMessageEvent;
import dev.robocode.tankroyale.schema.TickEventForBot;
import dev.robocode.tankroyale.schema.WonRoundEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class EventMapper {
    private EventMapper() {
    }

    public static TickEvent map(TickEventForBot event, IBaseBot baseBot) {
        return new TickEvent(event.getTurnNumber(), event.getRoundNumber(), BotStateMapper.map(event.getBotState()), BulletStateMapper.map(event.getBulletStates()), EventMapper.map(event.getEvents(), baseBot));
    }

    private static Set<BotEvent> map(Collection<Event> events, IBaseBot baseBot) {
        HashSet<BotEvent> gameBotEvents = new HashSet<BotEvent>();
        events.forEach(event -> gameBotEvents.add(EventMapper.map(event, baseBot)));
        return gameBotEvents;
    }

    public static BotEvent map(Event event, IBaseBot baseBot) {
        if (event instanceof BotDeathEvent) {
            return EventMapper.map((BotDeathEvent)event, baseBot.getMyId());
        }
        if (event instanceof BotHitBotEvent) {
            return EventMapper.map((BotHitBotEvent)event);
        }
        if (event instanceof BotHitWallEvent) {
            return EventMapper.map((BotHitWallEvent)event);
        }
        if (event instanceof BulletFiredEvent) {
            return EventMapper.map((BulletFiredEvent)event);
        }
        if (event instanceof BulletHitBotEvent) {
            return EventMapper.map((BulletHitBotEvent)event, baseBot.getMyId());
        }
        if (event instanceof BulletHitBulletEvent) {
            return EventMapper.map((BulletHitBulletEvent)event);
        }
        if (event instanceof dev.robocode.tankroyale.schema.BulletHitWallEvent) {
            return EventMapper.map((dev.robocode.tankroyale.schema.BulletHitWallEvent)event);
        }
        if (event instanceof dev.robocode.tankroyale.schema.ScannedBotEvent) {
            return EventMapper.map((dev.robocode.tankroyale.schema.ScannedBotEvent)event);
        }
        if (event instanceof dev.robocode.tankroyale.schema.SkippedTurnEvent) {
            return EventMapper.map((dev.robocode.tankroyale.schema.SkippedTurnEvent)event);
        }
        if (event instanceof WonRoundEvent) {
            return EventMapper.map((WonRoundEvent)event);
        }
        if (event instanceof TeamMessageEvent) {
            return EventMapper.map((TeamMessageEvent)event, baseBot);
        }
        throw new BotException("No mapping exists for event type: " + event.getClass().getSimpleName());
    }

    private static BotEvent map(BotDeathEvent source, int myBotId) {
        if (source.getVictimId() == myBotId) {
            return new DeathEvent(source.getTurnNumber());
        }
        return new dev.robocode.tankroyale.botapi.events.BotDeathEvent(source.getTurnNumber(), source.getVictimId());
    }

    private static HitBotEvent map(BotHitBotEvent source) {
        return new HitBotEvent(source.getTurnNumber(), source.getVictimId(), source.getEnergy(), source.getX(), source.getY(), source.getRammed());
    }

    private static HitWallEvent map(BotHitWallEvent source) {
        return new HitWallEvent(source.getTurnNumber());
    }

    private static dev.robocode.tankroyale.botapi.events.BulletFiredEvent map(BulletFiredEvent source) {
        return new dev.robocode.tankroyale.botapi.events.BulletFiredEvent(source.getTurnNumber(), BulletStateMapper.map(source.getBullet()));
    }

    private static BotEvent map(BulletHitBotEvent source, int myBotId) {
        BulletState bullet = BulletStateMapper.map(source.getBullet());
        if (source.getVictimId() == myBotId) {
            return new HitByBulletEvent(source.getTurnNumber(), bullet, source.getDamage(), source.getEnergy());
        }
        return new dev.robocode.tankroyale.botapi.events.BulletHitBotEvent(source.getTurnNumber(), source.getVictimId(), bullet, source.getDamage(), source.getEnergy());
    }

    private static dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent map(BulletHitBulletEvent source) {
        return new dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent(source.getTurnNumber(), BulletStateMapper.map(source.getBullet()), BulletStateMapper.map(source.getHitBullet()));
    }

    private static BulletHitWallEvent map(dev.robocode.tankroyale.schema.BulletHitWallEvent source) {
        return new BulletHitWallEvent(source.getTurnNumber(), BulletStateMapper.map(source.getBullet()));
    }

    private static ScannedBotEvent map(dev.robocode.tankroyale.schema.ScannedBotEvent source) {
        return new ScannedBotEvent(source.getTurnNumber(), source.getScannedByBotId(), source.getScannedBotId(), source.getEnergy(), source.getX(), source.getY(), source.getDirection(), source.getSpeed());
    }

    private static SkippedTurnEvent map(dev.robocode.tankroyale.schema.SkippedTurnEvent source) {
        return new SkippedTurnEvent(source.getTurnNumber());
    }

    private static dev.robocode.tankroyale.botapi.events.WonRoundEvent map(WonRoundEvent source) {
        return new dev.robocode.tankroyale.botapi.events.WonRoundEvent(source.getTurnNumber());
    }

    private static dev.robocode.tankroyale.botapi.events.TeamMessageEvent map(TeamMessageEvent source, IBaseBot baseBot) {
        String message = source.getMessage();
        if (message == null) {
            throw new BotException("message in TeamMessageEvent is null");
        }
        try {
            Class<?> type = baseBot.getClass().getClassLoader().loadClass(source.getMessageType());
            Object messageObject = JsonConverter.fromJson(message, type);
            return new dev.robocode.tankroyale.botapi.events.TeamMessageEvent(source.getTurnNumber(), messageObject, source.getSenderId());
        }
        catch (ClassNotFoundException e) {
            throw new BotException("Could not parse team message", e);
        }
    }
}

