/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi;

import dev.robocode.tankroyale.botapi.BulletState;
import dev.robocode.tankroyale.botapi.events.BotDeathEvent;
import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.BulletFiredEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitBotEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitBulletEvent;
import dev.robocode.tankroyale.botapi.events.BulletHitWallEvent;
import dev.robocode.tankroyale.botapi.events.Condition;
import dev.robocode.tankroyale.botapi.events.ConnectedEvent;
import dev.robocode.tankroyale.botapi.events.ConnectionErrorEvent;
import dev.robocode.tankroyale.botapi.events.CustomEvent;
import dev.robocode.tankroyale.botapi.events.DeathEvent;
import dev.robocode.tankroyale.botapi.events.DisconnectedEvent;
import dev.robocode.tankroyale.botapi.events.GameEndedEvent;
import dev.robocode.tankroyale.botapi.events.GameStartedEvent;
import dev.robocode.tankroyale.botapi.events.HitBotEvent;
import dev.robocode.tankroyale.botapi.events.HitByBulletEvent;
import dev.robocode.tankroyale.botapi.events.HitWallEvent;
import dev.robocode.tankroyale.botapi.events.RoundEndedEvent;
import dev.robocode.tankroyale.botapi.events.RoundStartedEvent;
import dev.robocode.tankroyale.botapi.events.ScannedBotEvent;
import dev.robocode.tankroyale.botapi.events.SkippedTurnEvent;
import dev.robocode.tankroyale.botapi.events.TeamMessageEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.events.WonRoundEvent;
import dev.robocode.tankroyale.botapi.graphics.Color;
import dev.robocode.tankroyale.botapi.graphics.IGraphics;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface IBaseBot {
    public static final int TEAM_MESSAGE_MAX_SIZE = 32768;
    public static final int MAX_NUMBER_OF_TEAM_MESSAGES_PER_TURN = 10;

    public void start();

    public void go();

    public int getMyId();

    public String getVariant();

    public String getVersion();

    public String getGameType();

    public int getArenaWidth();

    public int getArenaHeight();

    public int getNumberOfRounds();

    public double getGunCoolingRate();

    public int getMaxInactivityTurns();

    public int getTurnTimeout();

    public int getTimeLeft();

    public int getRoundNumber();

    public int getTurnNumber();

    public int getEnemyCount();

    public double getEnergy();

    public boolean isDisabled();

    public double getX();

    public double getY();

    public double getDirection();

    public double getGunDirection();

    public double getRadarDirection();

    public double getSpeed();

    public double getGunHeat();

    public Collection<BulletState> getBulletStates();

    public List<BotEvent> getEvents();

    public void clearEvents();

    public double getTurnRate();

    public void setTurnRate(double var1);

    public double getMaxTurnRate();

    public void setMaxTurnRate(double var1);

    public double getGunTurnRate();

    public void setGunTurnRate(double var1);

    public double getMaxGunTurnRate();

    public void setMaxGunTurnRate(double var1);

    public double getRadarTurnRate();

    public void setRadarTurnRate(double var1);

    public double getMaxRadarTurnRate();

    public void setMaxRadarTurnRate(double var1);

    public double getTargetSpeed();

    public void setTargetSpeed(double var1);

    public double getMaxSpeed();

    public void setMaxSpeed(double var1);

    public boolean setFire(double var1);

    public double getFirepower();

    public void setRescan();

    public void setFireAssist(boolean var1);

    public void setInterruptible(boolean var1);

    public void setAdjustGunForBodyTurn(boolean var1);

    public boolean isAdjustGunForBodyTurn();

    public void setAdjustRadarForBodyTurn(boolean var1);

    public boolean isAdjustRadarForBodyTurn();

    public void setAdjustRadarForGunTurn(boolean var1);

    public boolean isAdjustRadarForGunTurn();

    public boolean addCustomEvent(Condition var1);

    public boolean removeCustomEvent(Condition var1);

    public void setStop();

    public void setStop(boolean var1);

    public void setResume();

    public Set<Integer> getTeammateIds();

    public boolean isTeammate(int var1);

    public void broadcastTeamMessage(Object var1);

    public void sendTeamMessage(int var1, Object var2);

    public boolean isStopped();

    public Color getBodyColor();

    public void setBodyColor(Color var1);

    public Color getTurretColor();

    public void setTurretColor(Color var1);

    public Color getRadarColor();

    public void setRadarColor(Color var1);

    public Color getBulletColor();

    public void setBulletColor(Color var1);

    public Color getScanColor();

    public void setScanColor(Color var1);

    public Color getTracksColor();

    public void setTracksColor(Color var1);

    public Color getGunColor();

    public void setGunColor(Color var1);

    public boolean isDebuggingEnabled();

    public IGraphics getGraphics();

    default public void onConnected(ConnectedEvent connectedEvent) {
        System.out.println("Connected to: " + String.valueOf(connectedEvent.getServerUri()));
    }

    default public void onDisconnected(DisconnectedEvent disconnectedEvent) {
        StringBuilder msg = new StringBuilder("Disconnected from: " + String.valueOf(disconnectedEvent.getServerUri()));
        disconnectedEvent.getStatusCode().ifPresent(statusCode -> msg.append(", status code: ").append(statusCode));
        disconnectedEvent.getReason().ifPresent(reason -> msg.append(", reason: ").append((String)reason));
        System.out.println(msg);
    }

    default public void onConnectionError(ConnectionErrorEvent connectionErrorEvent) {
        System.err.println("Connection error with " + String.valueOf(connectionErrorEvent.getServerUri()));
        Throwable throwable = connectionErrorEvent.getError();
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    default public void onGameStarted(GameStartedEvent gameStatedEvent) {
    }

    default public void onGameEnded(GameEndedEvent gameEndedEvent) {
    }

    default public void onRoundStarted(RoundStartedEvent roundStartedEvent) {
    }

    default public void onRoundEnded(RoundEndedEvent roundEndedEvent) {
    }

    default public void onTick(TickEvent tickEvent) {
    }

    default public void onBotDeath(BotDeathEvent botDeathEvent) {
    }

    default public void onDeath(DeathEvent deathEvent) {
    }

    default public void onHitBot(HitBotEvent botHitBotEvent) {
    }

    default public void onHitWall(HitWallEvent botHitWallEvent) {
    }

    default public void onBulletFired(BulletFiredEvent bulletFiredEvent) {
    }

    default public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
    }

    default public void onBulletHit(BulletHitBotEvent bulletHitBotEvent) {
    }

    default public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
    }

    default public void onBulletHitWall(BulletHitWallEvent bulletHitWallEvent) {
    }

    default public void onScannedBot(ScannedBotEvent scannedBotEvent) {
    }

    default public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
    }

    default public void onWonRound(WonRoundEvent wonRoundEvent) {
    }

    default public void onCustomEvent(CustomEvent customEvent) {
    }

    default public void onTeamMessage(TeamMessageEvent teamMessageEvent) {
    }

    public double calcMaxTurnRate(double var1);

    public double calcBulletSpeed(double var1);

    public double calcGunHeat(double var1);

    public int getEventPriority(Class<BotEvent> var1);

    public void setEventPriority(Class<BotEvent> var1, int var2);

    default public double calcBearing(double direction) {
        return this.normalizeRelativeAngle(direction - this.getDirection());
    }

    default public double calcGunBearing(double direction) {
        return this.normalizeRelativeAngle(direction - this.getGunDirection());
    }

    default public double calcRadarBearing(double direction) {
        return this.normalizeRelativeAngle(direction - this.getRadarDirection());
    }

    default public double directionTo(double x, double y) {
        return this.normalizeAbsoluteAngle(Math.toDegrees(Math.atan2(y - this.getY(), x - this.getX())));
    }

    default public double bearingTo(double x, double y) {
        return this.normalizeRelativeAngle(this.directionTo(x, y) - this.getDirection());
    }

    default public double gunBearingTo(double x, double y) {
        return this.normalizeRelativeAngle(this.directionTo(x, y) - this.getGunDirection());
    }

    default public double radarBearingTo(double x, double y) {
        return this.normalizeRelativeAngle(this.directionTo(x, y) - this.getRadarDirection());
    }

    default public double distanceTo(double x, double y) {
        return Math.hypot(x - this.getX(), y - this.getY());
    }

    default public double normalizeAbsoluteAngle(double angle) {
        double d;
        return d >= 0.0 ? angle : (angle %= 360.0) + 360.0;
    }

    default public double normalizeRelativeAngle(double angle) {
        double d;
        return d >= 0.0 ? (angle < 180.0 ? angle : angle - 360.0) : (angle >= -180.0 ? angle : (angle %= 360.0) + 360.0);
    }

    default public double calcDeltaAngle(double targetAngle, double sourceAngle) {
        double angle;
        return angle += (angle = targetAngle - sourceAngle) > 180.0 ? -360.0 : (angle < -180.0 ? 360.0 : 0.0);
    }
}

