/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;

final class RecordingPrintStream
extends PrintStream {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final PrintStream printStream = new PrintStream(this.byteArrayOutputStream);

    public RecordingPrintStream(OutputStream out) {
        super(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        RecordingPrintStream recordingPrintStream = this;
        synchronized (recordingPrintStream) {
            super.write(b);
            this.printStream.write(b);
        }
    }

    @Override
    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buffer, int offset, int length) {
        RecordingPrintStream recordingPrintStream = this;
        synchronized (recordingPrintStream) {
            super.write(buffer, offset, length);
            this.printStream.write(buffer, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        RecordingPrintStream recordingPrintStream = this;
        synchronized (recordingPrintStream) {
            super.flush();
            this.printStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readNext() {
        RecordingPrintStream recordingPrintStream = this;
        synchronized (recordingPrintStream) {
            String output = this.byteArrayOutputStream.toString(StandardCharsets.UTF_8);
            this.byteArrayOutputStream.reset();
            return output;
        }
    }
}

