/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

final class EventHandler<T> {
    private static final int DEFAULT_PRIORITY = 1;
    private final Object lock = new Object();
    private final List<EntryWithPriority<T>> subscriberEntries = new ArrayList<EntryWithPriority<T>>();
    private final HashSet<Consumer<T>> subscriberSet = new HashSet();

    EventHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribe(Consumer<T> subscriber, int priority) {
        Objects.requireNonNull(subscriber, "Subscriber cannot be null");
        if (priority < 0) {
            throw new IllegalArgumentException("Priority must be a non-negative value");
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.subscriberSet.add(subscriber)) {
                throw new IllegalArgumentException("Subscriber is already registered");
            }
            this.subscriberEntries.add(new EntryWithPriority<T>(subscriber, priority));
            this.subscriberEntries.sort(Comparator.comparingInt(e -> e.priority).reversed());
        }
    }

    void subscribe(Consumer<T> subscriber) {
        this.subscribe(subscriber, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unsubscribe(Consumer<T> subscriber) {
        if (subscriber == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean removed = this.subscriberEntries.removeIf(entry -> entry.subscriber.equals(subscriber));
            if (removed) {
                this.subscriberSet.remove(subscriber);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.subscriberEntries.clear();
            this.subscriberSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish(T event) {
        ArrayList<EntryWithPriority<T>> entriesCopy;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            entriesCopy = new ArrayList<EntryWithPriority<T>>(this.subscriberEntries);
        }
        for (EntryWithPriority entryWithPriority : entriesCopy) {
            try {
                entryWithPriority.subscriber.accept(event);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSubscriberCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.subscriberEntries.size();
        }
    }

    private static class EntryWithPriority<T> {
        private final int priority;
        private final Consumer<T> subscriber;

        EntryWithPriority(Consumer<T> subscriber, int priority) {
            this.subscriber = subscriber;
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryWithPriority that = (EntryWithPriority)o;
            return this.priority == that.priority && Objects.equals(this.subscriber, that.subscriber);
        }

        public int hashCode() {
            return Objects.hash(this.priority, this.subscriber);
        }
    }
}

